/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.j2se.MOAgents;

import com.sun.management.j2se.MOAgents.EmmaManagedObjectInterface;
import com.sun.management.j2se.MOAgents.EmmaOptions;
import com.sun.management.j2se.MOAgents.MOAgentFactory;
import com.sun.management.j2se.MOAgents.MOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class EmmaAgentUtil {
    private static int count = 1;

    static synchronized ObjectName buildObjectName(EmmaManagedObjectInterface obj, MBeanServer server) throws MalformedObjectNameException {
        ObjectName name = null;
        if (obj == null || server == null) {
            return null;
        }
        EmmaOptions emmaOpts = obj.getEmmaOptions();
        if (emmaOpts == null) {
            System.out.println("\t!!! No EmmaOptions set for  " + obj + " cannot create Management Bean!!!");
            new Exception().printStackTrace();
            return null;
        }
        String classname = new String(obj.getClass().getName());
        StringBuffer tmpname = new StringBuffer(emmaOpts.getDomainName() + ":");
        Hashtable keyValues = emmaOpts.getKeyValues();
        Enumeration enumeration = keyValues.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            tmpname.append(key + "=");
            tmpname.append(keyValues.get(key));
            tmpname.append(",");
        }
        tmpname.append("objectType=" + classname + ",");
        tmpname.append("instanceID=" + count++ + ",");
        tmpname.append("jvmID=" + MOAgentFactory.getUniqueID(server) + ",");
        tmpname.append("domainName=" + emmaOpts.getDomainName());
        MOAgentFactory.echo("MOAGENT:Attempting to Register name = " + tmpname);
        name = new ObjectName(tmpname.toString());
        emmaOpts.setEmmaObjectName(name);
        return name;
    }

    static synchronized void register(EmmaManagedObjectInterface obj, MBeanServer server) throws MOException {
        ObjectName name = null;
        try {
            name = EmmaAgentUtil.buildObjectName(obj, server);
            if (server.isRegistered(name)) {
                throw new MOException("\t!!! Dynamic MBean already exists: " + name + "!!!");
            }
            MOAgentFactory.echo("\t Registering OBJECT NAME = " + name);
            server.registerMBean(obj, name);
        }
        catch (Exception e) {
            throw new MOException("\t!!! Could not Register Dynamic MBean: " + name + "!!!");
        }
    }

    static synchronized void unregister(EmmaManagedObjectInterface obj, MBeanServer server) {
        if (obj == null || server == null) {
            return;
        }
        EmmaOptions emmaOpts = obj.getEmmaOptions();
        ObjectName name = emmaOpts.getEmmaObjectName();
        if (name == null) {
            System.out.println("\t!!! Suppied name of Dynamic MBean is null: Unregister of " + obj + " failed!!!");
            new Exception().printStackTrace();
            return;
        }
        MOAgentFactory.echo("MOAGENT:Attempting to unegister name = " + name);
        try {
            if (!server.isRegistered(name)) {
                return;
            }
            MOAgentFactory.echo("\t Unregistering OBJECT NAME = " + name);
            server.unregisterMBean(name);
        }
        catch (Exception e) {
            System.out.println("\t!!! Could not unegister Dynamic MBean: " + name + "!!!");
            e.printStackTrace();
            return;
        }
    }
}

