/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.utils;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.Xid;

public class LogFormatter {
    public static String convertToString(byte[] byteArray) {
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            strBuf.append(byteArray[i]);
        }
        return strBuf.toString();
    }

    public static String convertXidArrayToString(Xid[] xidArray) {
        if (xidArray.length != 0) {
            StringBuffer strBuf = new StringBuffer("[ ");
            for (int i = 0; i < xidArray.length - 1; ++i) {
                strBuf.append(xidArray[i].getGlobalTransactionId()).append(", ");
            }
            strBuf.append(xidArray[xidArray.length - 1]).append(" ]");
            return strBuf.toString();
        }
        return " null ";
    }

    public static String convertPropsToString(Properties prop) {
        if (prop == null) {
            return "{null}";
        }
        StringBuffer strBuf = new StringBuffer("{ ");
        Enumeration<?> enumeration = prop.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            strBuf.append("[ ").append(obj).append("->");
            String val = prop.getProperty((String)obj);
            if (val == null) {
                strBuf.append("null");
            } else {
                strBuf.append(val);
            }
            strBuf.append(" ] ");
        }
        strBuf.append("}");
        return strBuf.toString();
    }

    public static String getLocalizedMessage(Logger logger, String key) {
        try {
            ResourceBundle rb = logger.getResourceBundle();
            String message = rb.getString(key);
            return message;
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "JTS:Error while localizing the log message");
            return key;
        }
    }

    public static String getLocalizedMessage(Logger logger, String key, Object[] args) {
        try {
            ResourceBundle rb = logger.getResourceBundle();
            String message = rb.getString(key);
            return MessageFormat.format(message, args);
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "JTS:Error while localizing the log message");
            return key;
        }
    }
}

