/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.Switch;
import com.sun.enterprise.security.jauth.callback.CertStoreCallback;
import com.sun.enterprise.security.jauth.callback.PasswordValidationCallback;
import com.sun.enterprise.security.jauth.callback.PrivateKeyCallback;
import com.sun.enterprise.security.jauth.callback.SecretKeyCallback;
import com.sun.enterprise.security.jauth.callback.TrustStoreCallback;
import com.sun.enterprise.webservice.AppclientWSSCallbackHandler;
import com.sun.enterprise.webservice.CertStoreProcessor;
import com.sun.enterprise.webservice.EjbServletWSSCallbackHandler;
import com.sun.enterprise.webservice.PasswordValidationProcessor;
import com.sun.enterprise.webservice.PrivateKeyProcessor;
import com.sun.enterprise.webservice.Processor;
import com.sun.enterprise.webservice.SecretKeyProcessor;
import com.sun.enterprise.webservice.TrustStoreProcessor;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public abstract class WSSCallbackHandler
implements CallbackHandler {
    static Logger _logger = null;
    int containerType = 2;

    static CallbackHandler getInstance() {
        if (Switch.getSwitch().getContainerType() == 1) {
            return AppclientWSSCallbackHandler.newInstance();
        }
        return EjbServletWSSCallbackHandler.newInstance();
    }

    abstract boolean isSupportedCallback(Callback var1);

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
    }

    void processCallback(Callback callback) throws UnsupportedCallbackException {
        Processor callbackProcessor = this.getHandlerProcessor(callback);
        if (callbackProcessor == null) {
            _logger.log(Level.FINE, "wss-container-auth: UnsupportedCallback : " + callback.getClass().getName());
            throw new UnsupportedCallbackException(callback);
        }
        callbackProcessor.process();
    }

    Processor getHandlerProcessor(Callback callback) {
        if (callback instanceof PasswordValidationCallback) {
            return new PasswordValidationProcessor(callback);
        }
        if (callback instanceof PrivateKeyCallback) {
            return new PrivateKeyProcessor(callback);
        }
        if (callback instanceof TrustStoreCallback) {
            return new TrustStoreProcessor(callback);
        }
        if (callback instanceof SecretKeyCallback) {
            return new SecretKeyProcessor(callback);
        }
        if (callback instanceof CertStoreCallback) {
            return new CertStoreProcessor(callback);
        }
        return null;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    }
}

