/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.security.wss.WebServiceSecurity;
import com.sun.enterprise.webservice.EjbRuntimeEndpointInfo;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.logging.LogDomains;
import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.rpc.spi.JaxRpcObjectFactory;
import com.sun.xml.rpc.spi.runtime.SOAPConstants;
import com.sun.xml.rpc.spi.runtime.SOAPMessageContext;
import com.sun.xml.rpc.spi.runtime.StreamingHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class EjbWebServiceDispatcher {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private JaxRpcObjectFactory rpcFactory;
    private WsUtil wsUtil = new WsUtil();
    private static final QName FAULT_CODE_CLIENT = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client");
    private static final String HTTP_SERVLET_RESPONSE = "com.sun.xml.rpc.server.http.HttpServletResponse";

    public EjbWebServiceDispatcher() {
        this.rpcFactory = JaxRpcObjectFactory.newInstance();
    }

    public void invoke(HttpServletRequest req, HttpServletResponse resp, EjbRuntimeEndpointInfo endpointInfo) {
        String method = req.getMethod();
        try {
            if (method.equals("POST")) {
                this.handlePost(req, resp, endpointInfo);
            } else if (method.equals("GET")) {
                this.handleGet(req, resp, endpointInfo);
            } else {
                String errorMessage = "Unsupported method request = [" + method + "] for endpoint " + endpointInfo.getEndpoint().getEndpointName() + " at " + endpointInfo.getEndpointAddressUri();
                logger.warning(errorMessage);
                this.wsUtil.writeInvalidMethodType(resp, errorMessage);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "ejb endpoint exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void handlePost(HttpServletRequest req, HttpServletResponse resp, EjbRuntimeEndpointInfo endpointInfo) throws IOException, SOAPException {
        try {
            headers = this.wsUtil.getHeaders(req);
            msgContext = this.rpcFactory.createSOAPMessageContext();
            message = this.createSOAPMessage(req, headers);
            sAC = null;
            wssSucceded = true;
            if (message != null) {
                msgContext.setMessage(message);
                implementor = null;
                try {
                    implementor = endpointInfo.getImplementor((MessageContext)msgContext);
                    msgContext.setProperty("com.sun.xml.rpc.server.http.HttpServletResponse", (Object)resp);
                    authConfig = endpointInfo.getServerAuthConfig();
                    if (authConfig != null && (sAC = authConfig.getAuthContext((StreamingHandler)implementor, message)) != null) {
                        wssSucceded = WebServiceSecurity.validateRequest((javax.xml.rpc.handler.soap.SOAPMessageContext)msgContext, sAC);
                    }
                    if (!wssSucceded) ** GOTO lbl25
                    implementor.handle(msgContext);
                }
                finally {
                    endpointInfo.releaseImplementor(implementor);
                }
            } else {
                errorMsg = "null message POSTed to ejb endpoint " + endpointInfo.getEndpoint().getEndpointName() + " at " + endpointInfo.getEndpointAddressUri();
                EjbWebServiceDispatcher.logger.fine(errorMsg);
                msgContext.writeSimpleErrorResponse(EjbWebServiceDispatcher.FAULT_CODE_CLIENT, errorMsg);
            }
lbl25:
            // 3 sources

            reply = msgContext.getMessage();
            if (sAC != null && wssSucceded) {
                WebServiceSecurity.secureResponse((javax.xml.rpc.handler.soap.SOAPMessageContext)msgContext, sAC);
            }
            if (reply.saveRequired()) {
                reply.saveChanges();
            }
            this.wsUtil.writeReply(resp, msgContext);
        }
        catch (Throwable e) {
            errorMessage = "invocation error on ejb endpoint " + endpointInfo.getEndpoint().getEndpointName() + " at " + endpointInfo.getEndpointAddressUri();
            EjbWebServiceDispatcher.logger.log(Level.WARNING, errorMessage, e);
            errorMsgContext = this.rpcFactory.createSOAPMessageContext();
            errorMsgContext.writeSimpleErrorResponse(SOAPConstants.FAULT_CODE_SERVER, errorMessage);
            resp.setStatus(500);
            this.wsUtil.writeReply(resp, errorMsgContext);
        }
    }

    private void handleGet(HttpServletRequest req, HttpServletResponse resp, EjbRuntimeEndpointInfo endpointInfo) throws IOException {
        this.wsUtil.handleGet(req, resp, endpointInfo.getEndpoint());
    }

    protected SOAPMessage createSOAPMessage(HttpServletRequest request, MimeHeaders headers) throws IOException {
        ServletInputStream is = request.getInputStream();
        byte[] bytes = this.readFully((InputStream)is);
        int length = request.getContentLength() == -1 ? bytes.length : request.getContentLength();
        ByteInputStream in = new ByteInputStream(bytes, length);
        SOAPMessageContext msgContext = this.rpcFactory.createSOAPMessageContext();
        SOAPMessage message = msgContext.createMessage(headers, (InputStream)in);
        return message;
    }

    protected byte[] readFully(InputStream istream) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int num = 0;
        while ((num = istream.read(buf)) != -1) {
            bout.write(buf, 0, num);
        }
        byte[] ret = bout.toByteArray();
        return ret;
    }
}

