/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.ejb.Container;
import com.sun.ejb.Invocation;
import com.sun.ejb.containers.StatelessSessionContainer;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.ServerAuthConfig;
import com.sun.enterprise.webservice.WSSCallbackHandler;
import com.sun.logging.LogDomains;
import com.sun.xml.rpc.spi.runtime.Handler;
import com.sun.xml.rpc.spi.runtime.Tie;
import java.rmi.Remote;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.rpc.handler.MessageContext;

public class EjbRuntimeEndpointInfo {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private WebServiceEndpoint endpoint;
    private StatelessSessionContainer container;
    private Remote webServiceEndpointServant;
    private Class tieClass;
    private ServerAuthConfig serverAuthConfig;
    private Tie tieInstance;
    private InvocationManager invManager;

    public EjbRuntimeEndpointInfo(WebServiceEndpoint webServiceEndpoint, StatelessSessionContainer ejbContainer, Remote servant, Class tie) {
        this.endpoint = webServiceEndpoint;
        this.container = ejbContainer;
        this.webServiceEndpointServant = servant;
        this.tieClass = tie;
        Switch theSwitch = Switch.getSwitch();
        this.invManager = theSwitch.getInvocationManager();
        try {
            this.serverAuthConfig = ServerAuthConfig.getConfig("SOAP", this.endpoint.getMessageSecurityBinding(), WSSCallbackHandler.getInstance());
        }
        catch (AuthException ae) {
            logger.log(Level.SEVERE, "EJB Webservice security configuration Failure", ae);
        }
    }

    public Container getContainer() {
        return this.container;
    }

    public WebServiceEndpoint getEndpoint() {
        return this.endpoint;
    }

    public ServerAuthConfig getServerAuthConfig() {
        return this.serverAuthConfig;
    }

    public String getEndpointAddressUri() {
        return this.endpoint.getEndpointAddressUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler getImplementor(MessageContext msgContext) throws Exception {
        Invocation inv = new Invocation();
        inv.isWebService = true;
        inv.container = this.container;
        inv.messageContext = msgContext;
        inv.transactionAttribute = 0;
        inv.securityPermissions = 0;
        this.invManager.preInvoke(inv);
        EjbRuntimeEndpointInfo ejbRuntimeEndpointInfo = this;
        synchronized (ejbRuntimeEndpointInfo) {
            if (this.tieInstance == null) {
                this.tieInstance = (Tie)this.tieClass.newInstance();
                this.tieInstance.setTarget(this.webServiceEndpointServant);
            }
        }
        inv.setWebServiceTie(this.tieInstance);
        return this.tieInstance;
    }

    public void releaseImplementor(Handler handler) {
        try {
            Invocation inv = (Invocation)this.invManager.getCurrentInvocation();
            if (inv != null) {
                if (inv.ejb != null) {
                    this.container.postInvoke(inv);
                } else {
                    this.invManager.postInvoke(inv);
                }
            }
        }
        catch (Throwable t) {
            logger.log(Level.FINE, "", t);
        }
    }
}

