/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.admin.common.JMXFileTransfer;
import com.sun.enterprise.admin.servermodel.AppServerInstance;
import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.deployment.archivist.InputJarArchive;
import com.sun.enterprise.deployment.util.DescriptorVisitor;
import com.sun.enterprise.deployment.util.WsdlFileVisitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipFile;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.MBeanServerConnection;

public class ClientWsdlPublisher {
    public void doWebServiceFilePublishing(AbstractArchive moduleArchive, WebService webService) throws IOException {
        if (!webService.hasFilePublishing()) {
            return;
        }
        URL clientPublishUrl = webService.getClientPublishUrl();
        ZipFile jarFile = null;
        try {
            File publishDir = new File(clientPublishUrl.getFile());
            BundleDescriptor bundle = webService.getBundleDescriptor();
            Enumeration entries = moduleArchive.entries();
            HashSet<String> entriesToPublish = new HashSet<String>();
            WsdlFileVisitor visitor = new WsdlFileVisitor();
            Set wsdlFileUris = new HashSet();
            if (bundle instanceof EjbBundleDescriptor) {
                ((EjbBundleDescriptor)bundle).visit(visitor);
                wsdlFileUris = visitor.getWsdlFileUris();
            } else if (bundle instanceof WebBundleDescriptor) {
                ((WebBundleDescriptor)bundle).visit((DescriptorVisitor)visitor);
                wsdlFileUris = visitor.getWsdlFileUris();
            }
            while (entries.hasMoreElements()) {
                String name = (String)entries.nextElement();
                if (!this.isWsdlContent(name, bundle) || wsdlFileUris.contains(name)) continue;
                entriesToPublish.add(name);
            }
            if (entriesToPublish.size() > 0) {
                String wsdlDir = this.getWsdlDir(bundle);
                Iterator iter = entriesToPublish.iterator();
                while (iter.hasNext()) {
                    boolean madeDirs;
                    String entryName = (String)iter.next();
                    String noWsdlDir = entryName.substring(wsdlDir.length() + 1);
                    String child = noWsdlDir.replace('/', File.separatorChar);
                    File outputFile = new File(publishDir, child);
                    File parentDir = outputFile.getParentFile();
                    if (!parentDir.exists() && !(madeDirs = parentDir.mkdirs())) {
                        throw new IOException("Error creating " + outputFile);
                    }
                    InputStream is = moduleArchive.getEntry(entryName);
                    FileOutputStream fos = new FileOutputStream(outputFile);
                    Archivist.copy(is, fos);
                }
            }
        }
        catch (IOException ioe) {
            IOException e = new IOException(ioe.getMessage());
            e.initCause(ioe);
            throw e;
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }

    public void retrieveWsdlFiles(AppServerInstance si, String applicationName, ModuleType moduleType, String sourceModule) throws Exception {
        this.retrieveWsdlFiles(si, applicationName, moduleType, sourceModule, null);
    }

    public void retrieveWsdlFiles(AppServerInstance si, String applicationName, ModuleType moduleType, String sourceModule, Application app) throws Exception {
        File sourceFile = new File(sourceModule);
        AbstractArchive jarInput = null;
        if (sourceFile.isDirectory()) {
            jarInput = new FileArchive();
            ((FileArchive)jarInput).open(sourceModule);
        } else {
            jarInput = new InputJarArchive();
            ((InputJarArchive)jarInput).open(sourceModule);
        }
        if (app == null) {
            ApplicationArchivist aa = new ApplicationArchivist();
            app = ApplicationArchivist.openArchive(new File(sourceModule));
        }
        int appType = 1001;
        if (moduleType.equals(ModuleType.EJB)) {
            appType = 1003;
        } else if (moduleType.equals(ModuleType.WAR)) {
            appType = 1002;
        }
        Iterator itr = app.getWebServiceDescriptors().iterator();
        while (itr.hasNext()) {
            AbstractArchive moduleArchive;
            WebService webService = (WebService)itr.next();
            if (!webService.hasFilePublishing()) continue;
            File publishDir = new File(webService.getClientPublishUrl().getFile());
            String moduleName = null;
            if (app.isVirtual()) {
                moduleArchive = jarInput;
            } else {
                moduleName = webService.getBundleDescriptor().getModuleDescriptor().getArchiveUri();
                moduleArchive = jarInput.getEmbeddedArchive(moduleName);
            }
            this.doWebServiceFilePublishing(moduleArchive, webService);
            si.exportWsdlFile(applicationName, moduleName, appType, webService.getWsdlFileUri(), publishDir.getAbsolutePath());
        }
    }

    public void retrieveWsdlFiles(SunTarget target, String applicationName, ModuleType moduleType, String sourceModule, Application app) throws Exception {
        File sourceFile = new File(sourceModule);
        AbstractArchive jarInput = null;
        if (sourceFile.isDirectory()) {
            jarInput = new FileArchive();
            ((FileArchive)jarInput).open(sourceModule);
        } else {
            jarInput = new InputJarArchive();
            ((InputJarArchive)jarInput).open(sourceModule);
        }
        if (app == null) {
            ApplicationArchivist aa = new ApplicationArchivist();
            app = ApplicationArchivist.openArchive(new File(sourceModule));
        }
        this.retrieveWsdlFiles(target, applicationName, moduleType, jarInput, app);
    }

    public void retrieveWsdlFiles(SunTarget target, String applicationName, ModuleType moduleType, AbstractArchive jarInput, Application app) throws Exception {
        int appType = 1001;
        if (moduleType.equals(ModuleType.EJB)) {
            appType = 1003;
        } else if (moduleType.equals(ModuleType.WAR)) {
            appType = 1002;
        }
        Iterator itr = app.getWebServiceDescriptors().iterator();
        while (itr.hasNext()) {
            AbstractArchive moduleArchive;
            WebService webService = (WebService)itr.next();
            if (!webService.hasFilePublishing()) continue;
            File publishDir = new File(webService.getClientPublishUrl().getFile());
            String moduleName = null;
            if (app.isVirtual()) {
                moduleArchive = jarInput;
            } else {
                moduleName = webService.getBundleDescriptor().getModuleDescriptor().getArchiveUri();
                moduleArchive = jarInput.getEmbeddedArchive(moduleName);
            }
            this.doWebServiceFilePublishing(moduleArchive, webService);
            target.exportWsdlFile(applicationName, moduleName, appType, webService.getWsdlFileUri(), publishDir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveWsdlFiles(MBeanServerConnection mbsc, String applicationName, String sourceModule, Application app) throws Exception {
        File sourceFile = new File(sourceModule);
        AbstractArchive jarInput = null;
        if (sourceFile.isDirectory()) {
            jarInput = new FileArchive();
            ((FileArchive)jarInput).open(sourceModule);
        } else {
            jarInput = new InputJarArchive();
            ((InputJarArchive)jarInput).open(sourceModule);
        }
        try {
            if (app == null) {
                ApplicationArchivist aa = new ApplicationArchivist();
                app = ApplicationArchivist.openArchive(new File(sourceModule));
            }
            Iterator itr = app.getWebServiceDescriptors().iterator();
            while (itr.hasNext()) {
                AbstractArchive moduleArchive;
                WebService webService = (WebService)itr.next();
                if (!webService.hasFilePublishing()) continue;
                File publishDir = new File(webService.getClientPublishUrl().getFile());
                String exportedPath = "";
                String moduleName = null;
                if (app.isVirtual()) {
                    moduleArchive = jarInput;
                } else {
                    moduleName = webService.getBundleDescriptor().getModuleDescriptor().getArchiveUri();
                    moduleArchive = jarInput.getEmbeddedArchive(moduleName);
                }
                this.doWebServiceFilePublishing(moduleArchive, webService);
                exportedPath = new JMXFileTransfer(mbsc).exportWsdlFile(applicationName, moduleName, webService.getWsdlFileUri(), publishDir.getAbsolutePath());
            }
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            try {
                if (jarInput != null) {
                    jarInput.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (jarInput != null) {
                jarInput.close();
            }
        }
        catch (Exception e) {}
    }

    public boolean isWsdlContent(String uri, BundleDescriptor bundle) {
        String wsdlDir = this.getWsdlDir(bundle);
        return uri != null && uri.startsWith(wsdlDir);
    }

    public String getWsdlDir(BundleDescriptor bundle) {
        boolean isWar = bundle instanceof WebBundleDescriptor;
        return isWar ? "WEB-INF/wsdl" : "META-INF/wsdl";
    }
}

