/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.stats;

import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.PWCVirtualServerStats;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatisticImpl;
import com.sun.enterprise.web.VirtualServer;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.Statistic;

public class PWCVirtualServerStatsImpl
implements PWCVirtualServerStats {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private long startTime;
    private GenericStatsImpl baseStatsImpl;
    private StringStatistic idStats;
    private StringStatistic modeStats;
    private StringStatistic hostsStats;
    private StringStatistic interfacesStats;

    public PWCVirtualServerStatsImpl(VirtualServer vs) {
        this.initializeStatistics(vs);
        try {
            this.baseStatsImpl = new GenericStatsImpl(this.getClass().getInterfaces()[0].getName(), (Object)this);
        }
        catch (ClassNotFoundException e) {
            _logger.log(Level.WARNING, "Error creating instance of GenericStatsImpl", e);
        }
    }

    public StringStatistic getId() {
        return this.idStats;
    }

    public StringStatistic getMode() {
        return this.modeStats;
    }

    public StringStatistic getHosts() {
        return this.hostsStats;
    }

    public StringStatistic getInterfaces() {
        return this.interfacesStats;
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }

    public Statistic getStatistic(String str) {
        return this.baseStatsImpl.getStatistic(str);
    }

    private void initializeStatistics(VirtualServer vs) {
        this.startTime = System.currentTimeMillis();
        this.idStats = new StringStatisticImpl(vs.getID(), "id", "String", "Virtual Server ID", this.startTime, this.startTime);
        this.modeStats = new StringStatisticImpl(vs.isActive() ? "active" : "unknown", "mode", "unknown/active", "Virtual Server mode", this.startTime, this.startTime);
        String hosts = null;
        String[] aliases = vs.findAliases();
        if (aliases != null) {
            for (int i = 0; i < aliases.length; ++i) {
                hosts = hosts == null ? aliases[i] : hosts + ", " + aliases[i];
            }
        }
        this.hostsStats = new StringStatisticImpl(hosts, "hosts", "String", "The software virtual hostnames serviced by this Virtual Server", this.startTime, this.startTime);
        this.interfacesStats = new StringStatisticImpl("0.0.0.0", "interfaces", "String", "The interfaces for which this Virtual Server has been configured", this.startTime, this.startTime);
    }
}

