/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.monitor.impl;

import com.sun.enterprise.web.monitor.PwcServletStats;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class PwcServletStatsImpl
implements PwcServletStats {
    private static Logger _logger = null;
    private transient MBeanServer server;
    private ObjectName servletObjName;

    public PwcServletStatsImpl(String domain, String vsId, String contextPath, String servletName, String appName, String serverName) {
        _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        this.server = servers != null && !servers.isEmpty() ? servers.get(0) : MBeanServerFactory.createMBeanServer();
        Hashtable<String, String> propList = new Hashtable<String, String>();
        propList.put("j2eeType", "Servlet");
        propList.put("name", servletName);
        propList.put("WebModule", this.createTomcatWebModuleName(vsId, contextPath));
        propList.put("J2EEApplication", appName);
        propList.put("J2EEServer", serverName);
        try {
            this.servletObjName = new ObjectName(domain, propList);
        }
        catch (MalformedObjectNameException mone) {
            _logger.info("Error creating the ObjectName " + mone.getMessage());
        }
        catch (NullPointerException npe) {
            _logger.info("Error creating the ObjectName ");
        }
    }

    public long getMaxTime() {
        return this.getLongValue(this.queryStatistic(this.servletObjName, "maxTime"));
    }

    public long getMinTime() {
        return this.getLongValue(this.queryStatistic(this.servletObjName, "minTime"));
    }

    public long getProcessingTime() {
        return this.getLongValue(this.queryStatistic(this.servletObjName, "processingTime"));
    }

    public int getRequestCount() {
        return this.getIntValue(this.queryStatistic(this.servletObjName, "requestCount"));
    }

    public int getErrorCount() {
        return this.getIntValue(this.queryStatistic(this.servletObjName, "errorCount"));
    }

    private Object queryStatistic(ObjectName on, String attrName) {
        Object resultObj = null;
        try {
            resultObj = this.server.getAttribute(on, attrName);
        }
        catch (MBeanException mbe) {
            _logger.info("MBeanException in queryStatistic " + mbe.getMessage());
        }
        catch (AttributeNotFoundException anfe) {
            _logger.info("Attribute being queried does not exist: " + attrName);
        }
        catch (InstanceNotFoundException infe) {
            _logger.info("MBean being queried is not registered: " + on.toString());
        }
        catch (ReflectionException re) {
            _logger.info("ReflectionException in queryStatistic " + re.getMessage());
        }
        catch (Exception e) {
            _logger.info("Exception in queryStatistic " + e.getMessage());
        }
        return resultObj;
    }

    private String createTomcatWebModuleName(String vsId, String contextPath) {
        String PREFIX = "//";
        String tcWebModuleName = contextPath != null && !contextPath.equals("") ? "//" + vsId + contextPath : "//" + vsId + "/";
        return tcWebModuleName;
    }

    private long getLongValue(Object resultObj) {
        long result = 0L;
        if (resultObj != null) {
            Long countObj = (Long)resultObj;
            result = countObj;
        }
        return result;
    }

    private int getIntValue(Object resultObj) {
        int result = 0;
        if (resultObj != null) {
            Integer countObj = (Integer)resultObj;
            result = countObj;
        }
        return result;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        this.server = servers != null && !servers.isEmpty() ? servers.get(0) : MBeanServerFactory.createMBeanServer();
    }
}

