/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.NonBlockingPipedInputStream;
import com.sun.enterprise.web.connector.grizzly.NonBlockingPipedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class TaskContext {
    private InputStream inputStream;
    private OutputStream outputStream;

    public TaskContext(boolean useDefaultStream) {
        if (useDefaultStream) {
            try {
                this.initializedStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    private void initializedStream() throws IOException {
        this.outputStream = new NonBlockingPipedOutputStream();
        this.inputStream = new NonBlockingPipedInputStream((NonBlockingPipedOutputStream)this.outputStream);
    }

    public synchronized void write(ByteBuffer byteBuffer, int len) throws IOException {
        ((NonBlockingPipedOutputStream)this.outputStream).write(byteBuffer, len);
    }

    public synchronized void write(byte[] buff) throws IOException {
        this.outputStream.write(buff, 0, buff.length);
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void recycle() throws IOException {
        this.inputStream.close();
    }
}

