/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.Pipeline;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.enterprise.web.connector.grizzly.TaskEvent;
import com.sun.enterprise.web.connector.grizzly.TaskListener;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.logging.Logger;

public abstract class TaskBase
implements Task {
    protected static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    protected int type;
    protected ArrayList listeners = new ArrayList();
    protected Pipeline pipeline;
    protected SelectionKey key;
    protected boolean hasBeenReturned = false;
    protected SelectorThread selectorThread;

    public SelectionKey getSelectionKey() {
        return this.key;
    }

    public void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    public int getType() {
        return this.type;
    }

    public void setSelectorThread(SelectorThread selectorThread) {
        this.selectorThread = selectorThread;
    }

    public SelectorThread getSelectorThread() {
        return this.selectorThread;
    }

    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void execute() {
        if (this.pipeline != null) {
            this.pipeline.addTask(this);
        } else {
            try {
                this.doTask();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void addTaskListener(TaskListener task) {
        this.listeners.add(task);
    }

    public void removeTaskListener(TaskListener task) {
        this.listeners.remove(task);
    }

    public void clearListener() {
        this.listeners.clear();
    }

    public void taskStarted(TaskEvent event) {
    }

    public void taskCompleted(TaskEvent event) {
    }

    protected void notifyTaskStarted(TaskEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TaskListener)this.listeners.get(i)).taskStarted(event);
        }
    }

    protected void notifyTaskCompleted(TaskEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TaskListener)this.listeners.get(i)).taskCompleted(event);
        }
    }

    public void recycle() {
        this.listeners.clear();
    }
}

