/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.WorkerThread;
import java.util.ArrayList;

public class Pipeline
extends ArrayList {
    private int waitingThreads = 0;
    private int maxThreads = 50;
    private int minThreads = 10;
    private int minSpareThreads = 5;
    private int port = 8080;
    private int threadCount = 0;
    private String name;
    private WorkerThread[] workerThreads;

    public Pipeline(int maxThreads, int minThreads, String name, int port, int minSpareThreads) {
        super(maxThreads);
        this.maxThreads = maxThreads;
        this.port = port;
        this.name = name;
        this.minThreads = minThreads;
        this.minSpareThreads = minSpareThreads;
        if (minThreads > maxThreads) {
            minThreads = maxThreads;
        }
        this.workerThreads = new WorkerThread[maxThreads];
    }

    public synchronized void addTask(Object obj) {
        this.add(obj);
        this.notify();
        if (this.waitingThreads < this.minSpareThreads && this.threadCount < this.maxThreads) {
            this.increaseWorkerThread();
        }
    }

    public synchronized Object getTask() {
        if (this.isEmpty()) {
            try {
                ++this.waitingThreads;
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            --this.waitingThreads;
        }
        return this.remove(this.size() - 1);
    }

    public boolean isEmpty() {
        return this.size() - this.waitingThreads <= 0;
    }

    public int getWaitingThread() {
        return this.waitingThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getCurrentThreadCount() {
        return this.maxThreads - (this.threadCount - this.waitingThreads);
    }

    public int getCurrentThreadsBusy() {
        return this.threadCount - this.waitingThreads;
    }

    public int getMaxSpareThreads() {
        return this.waitingThreads;
    }

    public int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
    }

    public void initPipeline() {
        int min = this.minThreads > this.maxThreads ? this.maxThreads : this.minThreads;
        for (int i = 0; i < min; ++i) {
            this.workerThreads[i] = new WorkerThread(this);
            this.workerThreads[i].setName(this.name + "WorkerThread-" + this.port + "-" + this.threadCount);
            ++this.threadCount;
        }
    }

    public String getName() {
        return this.name + this.port;
    }

    public void startPipeline() {
        int min = this.minThreads > this.maxThreads ? this.maxThreads : this.minThreads;
        for (int i = 0; i < min; ++i) {
            this.workerThreads[i].start();
        }
    }

    public void stopPipeline() {
        int min = this.minThreads > this.maxThreads ? this.maxThreads : this.minThreads;
        for (int i = 0; i < min; ++i) {
            this.workerThreads[i].terminate();
        }
    }

    protected void increaseWorkerThread() {
        WorkerThread workerThread = new WorkerThread(this);
        workerThread.setName(this.name + "WorkerThread-" + this.port + "-" + this.threadCount);
        workerThread.start();
        ++this.threadCount;
    }
}

