/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.NonBlockingPipedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class NonBlockingPipedOutputStream
extends OutputStream {
    private NonBlockingPipedInputStream sink;

    public NonBlockingPipedOutputStream(NonBlockingPipedInputStream snk) throws IOException {
        this.connect(snk);
    }

    public NonBlockingPipedOutputStream() {
    }

    public void connect(NonBlockingPipedInputStream snk) throws IOException {
        if (snk == null) {
            throw new NullPointerException();
        }
        if (this.sink != null || snk.connected) {
            throw new IOException("Already connected");
        }
        this.sink = snk;
        snk.in = -1;
        snk.out = 0;
        snk.connected = true;
    }

    public void write(int b) throws IOException {
        if (this.sink == null) {
            throw new IOException("Pipe not connected");
        }
        this.sink.receive(b);
    }

    public void write(ByteBuffer byteBuffer, int len) throws IOException {
        this.sink.receive(byteBuffer, len);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.sink == null) {
            throw new IOException("Pipe not connected");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.sink.receive(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        if (this.sink != null) {
            NonBlockingPipedInputStream nonBlockingPipedInputStream = this.sink;
            synchronized (nonBlockingPipedInputStream) {
                this.sink.notifyAll();
            }
        }
    }

    public void close() throws IOException {
        if (this.sink != null) {
            this.sink.receivedLast();
        }
    }
}

