/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.Constants;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.modeler.Registry;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.ServerSocketFactory;

public class GrizzlyHttpProtocol
implements ProtocolHandler,
MBeanRegistration {
    protected boolean secure;
    protected ServerSocketFactory socketFactory;
    protected SSLImplementation sslImplementation;
    protected Hashtable attributes = new Hashtable();
    protected String socketFactoryName = null;
    protected String sslImplementationName = null;
    private int timeout = 300000;
    private int maxPostSize = 0x200000;
    private int maxHttpHeaderSize = 4096;
    private int socketCloseDelay = -1;
    private boolean disableUploadTimeout = true;
    private int socketBuffer = 9000;
    private Adapter adapter;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;
    private SelectorThread selectorThread = new SelectorThread();
    private String compression = "off";
    private String noCompressionUserAgents = null;
    private String restrictedUserAgents = null;
    private String compressableMimeTypes = "text/html,text/xml,text/plain";
    private int compressionMinSize = 2048;
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private int requestBufferSize = 4096;

    public GrizzlyHttpProtocol() {
        this.setSoLinger(-1);
        this.setSoTimeout(Constants.DEFAULT_CONNECTION_TIMEOUT);
        this.setServerSoTimeout(0);
        this.setTcpNoDelay(true);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setProperty(String name, String value) {
        this.setAttribute(name, value);
    }

    public String getProperty(String name) {
        return (String)this.getAttribute(name);
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public void init() throws Exception {
        try {
            this.checkSocketFactory();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "grizzlyHttpProtocol.socketfactory.initerror", ex);
            throw ex;
        }
        if (this.socketFactory != null) {
            Enumeration attE = this.attributes.keys();
            while (attE.hasMoreElements()) {
                String key = (String)attE.nextElement();
                Object v = this.attributes.get(key);
                this.socketFactory.setAttribute(key, v);
            }
        }
        try {
            this.selectorThread.setAdapter(this.adapter);
            this.selectorThread.initEndpoint();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "grizzlyHttpProtocol.endpoint.initerror", ex);
            throw ex;
        }
        logger.log(Level.INFO, "grizzlyHttpProtocol.init", String.valueOf(this.getPort()));
    }

    public void start() throws Exception {
        try {
            if (this.oname != null) {
                try {
                    Registry.getRegistry().registerComponent(this.selectorThread, this.domain, "selectorThread", "type=Selector");
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "grizzlyHttpProtocol.selectorRegistrationFailed", ex);
                }
            } else {
                logger.log(Level.INFO, "grizzlyHttpProtocol.selectorRegisterProtocol");
            }
            this.selectorThread.start();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "grizzlyHttpProtocol.endpoint.starterror", ex);
            throw ex;
        }
        logger.log(Level.INFO, "grizzlyHttpProtocol.start", String.valueOf(this.getPort()));
    }

    public void pause() throws Exception {
        try {
            this.selectorThread.pauseEndpoint();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "grizzlyHttpProtocol.endpoint.pauseerror", ex);
            throw ex;
        }
        logger.log(Level.INFO, "grizzlyHttpProtocol.pause", String.valueOf(this.getPort()));
    }

    public void resume() throws Exception {
        try {
            this.selectorThread.resumeEndpoint();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "grizzlyHttpProtocol.endpoint.resumeerror", ex);
            throw ex;
        }
        logger.log(Level.INFO, "grizzlyHttpProtocol.resume", String.valueOf(this.getPort()));
    }

    public void destroy() throws Exception {
        logger.log(Level.INFO, "grizzlyHttpProtocol.stop", String.valueOf(this.getPort()));
        Registry.getRegistry().unregisterComponent(new ObjectName(this.domain, "type", "Selector"));
        this.selectorThread.stopEndpoint();
    }

    public int getMaxThreads() {
        return this.selectorThread.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.selectorThread.setMaxThreads(maxThreads);
        this.setAttribute("maxThreads", "" + maxThreads);
    }

    public int getMaxSpareThreads() {
        return this.selectorThread.getMaxSpareThreads();
    }

    public void setMaxSpareThreads(int maxThreads) {
        this.selectorThread.setMaxSpareThreads(maxThreads);
        this.setAttribute("maxSpareThreads", "" + maxThreads);
    }

    public int getMinSpareThreads() {
        return this.selectorThread.getMinSpareThreads();
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.selectorThread.setMinSpareThreads(minSpareThreads);
        this.setAttribute("minSpareThreads", "" + minSpareThreads);
    }

    public int getBacklog() {
        return this.selectorThread.getBacklog();
    }

    public void setBacklog(int i) {
        this.selectorThread.setBacklog(i);
        this.setAttribute("backlog", "" + i);
    }

    public int getPort() {
        return this.selectorThread.getPort();
    }

    public void setPort(int port) {
        this.selectorThread.setPort(port);
        this.setAttribute("port", "" + port);
    }

    public InetAddress getAddress() {
        return this.selectorThread.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.selectorThread.setAddress(ia);
        this.setAttribute("address", "" + ia);
    }

    public String getName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = "" + this.getAddress();
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr) + "-";
        }
        return "http-" + encodedAddr + this.selectorThread.getPort();
    }

    public String getSocketFactory() {
        return this.socketFactoryName;
    }

    public void setSocketFactory(String valueS) {
        this.socketFactoryName = valueS;
        this.setAttribute("socketFactory", valueS);
    }

    public boolean getTcpNoDelay() {
        return this.selectorThread.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean b) {
        this.selectorThread.setTcpNoDelay(b);
        this.setAttribute("tcpNoDelay", "" + b);
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setSocketBuffer(int valueI) {
        this.socketBuffer = valueI;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String valueS) {
        this.compression = valueS;
        this.setAttribute("compression", valueS);
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(int valueI) {
        this.maxPostSize = valueI;
        this.setAttribute("maxPostSize", "" + valueI);
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        this.maxHttpHeaderSize = maxHttpHeaderSize;
        this.selectorThread.setMaxHttpHeaderSize(maxHttpHeaderSize);
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String valueS) {
        this.restrictedUserAgents = valueS;
        this.setAttribute("restrictedUserAgents", valueS);
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String valueS) {
        this.noCompressionUserAgents = valueS;
        this.setAttribute("noCompressionUserAgents", valueS);
    }

    public String getCompressableMimeType() {
        return this.compressableMimeTypes;
    }

    public void setCompressableMimeType(String valueS) {
        this.compressableMimeTypes = valueS;
        this.setAttribute("compressableMimeTypes", valueS);
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int valueI) {
        this.compressionMinSize = valueI;
        this.setAttribute("compressionMinSize", "" + valueI);
    }

    public int getSoLinger() {
        return this.selectorThread.getSoLinger();
    }

    public void setSoLinger(int i) {
        this.selectorThread.setSoLinger(i);
        this.setAttribute("soLinger", "" + i);
    }

    public int getSoTimeout() {
        return this.selectorThread.getSoTimeout();
    }

    public void setSoTimeout(int i) {
        this.selectorThread.setSoTimeout(i);
        this.setAttribute("soTimeout", "" + i);
    }

    public int getServerSoTimeout() {
        return this.selectorThread.getServerSoTimeout();
    }

    public void setServerSoTimeout(int i) {
        this.selectorThread.setServerSoTimeout(i);
        this.setAttribute("serverSoTimeout", "" + i);
    }

    public String getKeystore() {
        return this.getProperty("keystore");
    }

    public void setKeystore(String k) {
        this.setAttribute("keystore", k);
    }

    public String getKeypass() {
        return this.getProperty("keypass");
    }

    public void setKeypass(String k) {
        this.attributes.put("keypass", k);
    }

    public String getKeytype() {
        return this.getProperty("keystoreType");
    }

    public void setKeytype(String k) {
        this.setAttribute("keystoreType", k);
    }

    public String getClientauth() {
        return this.getProperty("clientauth");
    }

    public void setClientauth(String k) {
        this.setAttribute("clientauth", k);
    }

    public String getProtocol() {
        return this.getProperty("protocol");
    }

    public void setProtocol(String k) {
        this.setAttribute("protocol", k);
    }

    public String getProtocols() {
        return this.getProperty("protocols");
    }

    public void setProtocols(String k) {
        this.setAttribute("protocols", k);
    }

    public String getAlgorithm() {
        return this.getProperty("algorithm");
    }

    public void setAlgorithm(String k) {
        this.setAttribute("algorithm", k);
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean b) {
        this.secure = b;
        this.setAttribute("secure", "" + b);
        this.selectorThread.setSecure(b);
    }

    public String getCiphers() {
        return this.getProperty("ciphers");
    }

    public void setCiphers(String ciphers) {
        this.setAttribute("ciphers", ciphers);
    }

    public String getKeyAlias() {
        return this.getProperty("keyAlias");
    }

    public void setKeyAlias(String keyAlias) {
        this.setAttribute("keyAlias", keyAlias);
    }

    public int getSocketCloseDelay() {
        return this.socketCloseDelay;
    }

    public void setSocketCloseDelay(int d) {
        this.socketCloseDelay = d;
        this.setAttribute("socketCloseDelay", "" + d);
    }

    private static ServerSocketFactory string2SocketFactory(String val) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> chC = Class.forName(val);
        return (ServerSocketFactory)chC.newInstance();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeouts) {
        this.timeout = timeouts * 1000;
        this.setAttribute("timeout", "" + timeouts);
    }

    private void checkSocketFactory() throws Exception {
        if (this.secure) {
            this.sslImplementation = SSLImplementation.getInstance(this.sslImplementationName);
            this.socketFactory = this.sslImplementation.getServerSocketFactory();
            this.selectorThread.setServerSocketFactory(this.socketFactory);
            this.selectorThread.setSSLImplementation(this.sslImplementation);
        }
        if (this.socketFactoryName != null) {
            this.socketFactory = GrizzlyHttpProtocol.string2SocketFactory(this.socketFactoryName);
            this.selectorThread.setServerSocketFactory(this.socketFactory);
        }
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.selectorThread.setMaxKeepAliveRequests(mkar);
    }

    public void setMinThreads(int minThreads) {
        this.selectorThread.setMinThreads(minThreads);
    }

    public void setBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
        this.selectorThread.setBufferSize(requestBufferSize);
    }

    public int getBufferSize() {
        return this.requestBufferSize;
    }
}

