/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.web.TomcatDeploymentConfig;
import com.sun.enterprise.web.WebModule;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.startup.ContextConfig;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class WebModuleContextConfig
extends ContextConfig {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    public static final int CHILDREN = 0;
    public static final int SERVLET_MAPPINGS = 1;
    public static final int LOCAL_EJBS = 2;
    public static final int EJBS = 3;
    public static final int ENVIRONMENTS = 4;
    public static final int ERROR_PAGES = 5;
    public static final int FILTER_DEFS = 6;
    public static final int FILTER_MAPS = 7;
    public static final int APPLICATION_LISTENERS = 8;
    public static final int RESOURCES = 9;
    public static final int APPLICATION_PARAMETERS = 10;
    public static final int MESSAGE_DESTINATIONS = 11;
    public static final int MESSAGE_DESTINATION_REFS = 12;
    public static final int MIME_MAPPINGS = 13;
    protected WebModule defaultWebModule;
    protected File file;
    private WebBundleDescriptor webBundleDescriptor;

    public WebModuleContextConfig(WebModule webModule) {
        this.defaultWebModule = webModule;
    }

    public void setDescriptor(WebBundleDescriptor wbd) {
        this.webBundleDescriptor = wbd;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.context = (Context)((Object)event.getLifecycle());
        }
        catch (ClassCastException e) {
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    protected synchronized void start() {
        try {
            if (!this.defaultWebModule.hasBeenXmlConfigured()) {
                this.defaultConfig();
                this.defaultWebModule.setXmlConfigured(true);
                this.extractWebModuleInformation();
            }
            TomcatDeploymentConfig.configureWebModule((WebModule)this.context, this.defaultWebModule);
            TomcatDeploymentConfig.configureWebModule((WebModule)this.context, this.webBundleDescriptor);
        }
        catch (Throwable t) {
            this.context.setAvailable(false);
            Object[] objs = new Object[]{this.context.getName(), t};
            logger.log(Level.SEVERE, "webModuleContextConfig.webModuleDisabled", objs);
        }
        this.context.setConfigured(false);
        this.authenticatorConfig();
        this.managerConfig();
        this.context.setConfigured(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void defaultConfig() {
        if (this.defaultWebXml == null) {
            this.defaultWebXml = this.defaultWebModule.getDefaultWebXml();
        }
        if (this.defaultWebXml == null) {
            this.getDefaultWebXml();
        }
        if (this.file == null) {
            this.file = new File(this.defaultWebXml);
            if (!this.file.isAbsolute()) {
                this.file = new File(this.getBaseDir(), this.defaultWebXml);
            }
        }
        stream = null;
        source = null;
        try {
            if (this.file.exists()) ** GOTO lbl20
            stream = this.getClass().getClassLoader().getResourceAsStream(this.defaultWebXml);
            if (stream != null) {
                source = new InputSource(this.getClass().getClassLoader().getResource(this.defaultWebXml).toString());
            } else {
                WebModuleContextConfig.logger.log(Level.SEVERE, "webModuleContextConfig.missingDefaultWeb.xml");
                return;
lbl20:
                // 1 sources

                source = new InputSource("file://" + this.file.getAbsolutePath());
                stream = new FileInputStream(this.file);
            }
        }
        catch (Exception e) {
            WebModuleContextConfig.logger.log(Level.SEVERE, "webModuleContextConfig.missingDefaultWeb.xml", e);
            return;
        }
        if (WebModuleContextConfig.webDigester == null) {
            WebModuleContextConfig.webDigester = WebModuleContextConfig.createWebDigester();
        }
        var3_4 = WebModuleContextConfig.webDigester;
        synchronized (var3_4) {
            block26: {
                source.setByteStream(stream);
                WebModuleContextConfig.webDigester.setDebug(this.getDebug());
                this.defaultWebModule.setReplaceWelcomeFiles(true);
                WebModuleContextConfig.webDigester.clear();
                WebModuleContextConfig.webDigester.setClassLoader(this.getClass().getClassLoader());
                WebModuleContextConfig.webDigester.setUseContextClassLoader(false);
                WebModuleContextConfig.webDigester.push(this.defaultWebModule);
                WebModuleContextConfig.webDigester.parse(source);
                var6_5 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    break block26;
                }
                catch (IOException e) {
                    WebModuleContextConfig.logger.log(Level.SEVERE, "webModuleContextConfig.defaultClose", e);
                }
                break block26;
                {
                    catch (SAXParseException e) {
                        WebModuleContextConfig.logger.log(Level.SEVERE, "webModuleContextConfig.defaultParse", e);
                        this.ok = false;
                        var6_6 = null;
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block26;
                        }
                        catch (IOException e) {
                            WebModuleContextConfig.logger.log(Level.SEVERE, "webModuleContextConfig.defaultClose", e);
                        }
                        break block26;
                    }
                    catch (Exception e) {
                        WebModuleContextConfig.logger.log(Level.SEVERE, "webModuleContextConfig.defaultParse", e);
                        this.ok = false;
                        var6_7 = null;
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block26;
                        }
                        catch (IOException e) {
                            WebModuleContextConfig.logger.log(Level.SEVERE, "webModuleContextConfig.defaultClose", e);
                        }
                    }
                }
                catch (Throwable var5_15) {
                    var6_8 = null;
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException e) {
                        WebModuleContextConfig.logger.log(Level.SEVERE, "webModuleContextConfig.defaultClose", e);
                    }
                    throw var5_15;
                }
            }
        }
        WebModuleContextConfig.webRuleSet.recycle();
    }

    private void extractWebModuleInformation() {
        Object[] defaultWebModuleFindCache = new Object[]{this.defaultWebModule.findChildren(), this.defaultWebModule.findServletMappings(), this.defaultWebModule.findLocalEjbs(), this.defaultWebModule.findEjbs(), this.defaultWebModule.findEnvironments(), this.defaultWebModule.findErrorPages(), this.defaultWebModule.findFilterDefs(), this.defaultWebModule.findFilterMaps(), this.defaultWebModule.findApplicationListeners(), this.defaultWebModule.findResources(), this.defaultWebModule.findApplicationParameters(), this.defaultWebModule.findMessageDestinations(), this.defaultWebModule.findMessageDestinationRefs(), this.defaultWebModule.findMimeMappings()};
        this.defaultWebModule.setCachedFindOperation(defaultWebModuleFindCache);
    }

    protected String getBaseDir() {
        Container engineC = this.defaultWebModule.getParent();
        if (engineC instanceof StandardEngine) {
            return ((StandardEngine)engineC).getBaseDir();
        }
        return System.getProperty("catalina.base");
    }
}

