/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.sync;

import com.sun.enterprise.util.pool.TimedoutException;

public class Lock {
    private Thread owner = null;
    private int lockCount = 0;

    public synchronized void acquireLock() throws InterruptedException {
        while (!this.tryGetLock()) {
            this.wait();
        }
    }

    public synchronized void acquireLock(long waitTime) throws InterruptedException, TimedoutException {
        if (!this.tryGetLock() && waitTime != 0L) {
            if (waitTime == -1L) {
                while (!this.tryGetLock()) {
                    this.wait();
                }
            } else {
                boolean isWaiting = true;
                long startTime = System.currentTimeMillis();
                long timeRemaining = waitTime;
                while (isWaiting) {
                    this.wait(timeRemaining);
                    if (this.tryGetLock()) {
                        return;
                    }
                    timeRemaining = startTime + waitTime - System.currentTimeMillis();
                    isWaiting = timeRemaining > 0L;
                }
                throw new TimedoutException();
            }
        }
    }

    private boolean tryGetLock() {
        Thread t = Thread.currentThread();
        if (this.owner == null) {
            this.owner = t;
            this.lockCount = 1;
            return true;
        }
        if (this.owner == t) {
            ++this.lockCount;
            return true;
        }
        return false;
    }

    public synchronized void releaseLock() {
        if (!this.owner.equals(Thread.currentThread())) {
            throw new IllegalMonitorStateException();
        }
        if (--this.lockCount == 0) {
            this.owner = null;
            this.notify();
        }
    }

    public synchronized boolean isLocked() {
        return this.owner != null;
    }

    public Thread getOwner() {
        return this.owner;
    }
}

