/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.scheduler;

import com.sun.enterprise.util.ApproximateClock;
import com.sun.enterprise.util.scheduler.PeriodicallyServicable;
import com.sun.enterprise.util.scheduler.TaskData;
import com.sun.enterprise.util.scheduler.TimedTaskList;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PeriodicEventScheduler
implements Runnable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    protected Thread _thread;
    private static PeriodicEventScheduler _instance = null;
    private static Object instanceLock = new Object();
    protected TimedTaskList sortedList = new TimedTaskList();
    protected boolean bRun = true;
    protected boolean bDebug = false;
    protected transient long counter = 0L;
    protected long delay_time_approx = 100L;
    protected ApproximateClock clock = new ApproximateClock(this.delay_time_approx);
    private PeriodicallyServicable executingTask = null;
    private boolean removeExecutingTask = false;

    public static PeriodicEventScheduler getInstance() {
        return _instance;
    }

    private PeriodicEventScheduler() {
        this.counter = this.getTime();
        this._thread = new Thread((Runnable)this, "PeriodicEventScheduler");
        this._thread.setDaemon(true);
        this._thread.start();
    }

    private long getTime() {
        return this.clock.getActualTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addTimeRepeatableTask(PeriodicallyServicable obj, int startingTime) {
        if (startingTime < 0 || obj.getFrequency() < 1L) {
            _logger.log(Level.FINE, "PeriodicEventScheduler::addTimeRepeatableTask() rejected task" + ((Object)obj).toString());
            return false;
        }
        boolean bool = this.sortedList.addTask(obj, startingTime, this.counter);
        Object object = instanceLock;
        synchronized (object) {
            instanceLock.notify();
        }
        return bool;
    }

    public synchronized boolean removeTimeRepeatableTask(PeriodicallyServicable obj) {
        if (this.executingTask.equals(obj)) {
            this.removeExecutingTask = true;
            return true;
        }
        return this.sortedList.removeTask(obj);
    }

    protected synchronized boolean insertSorted(TaskData taskObj) {
        return this.sortedList.insertTask(taskObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        TaskData task = null;
        while (true) {
            Object var6_7;
            block29: {
                block28: {
                    block27: {
                        block26: {
                            if (!this.bRun) {
                                return;
                            }
                            try {
                                try {
                                    task = this.sortedList.getFirstTask();
                                    if (null == task) {
                                        Object object = instanceLock;
                                        synchronized (object) {
                                            instanceLock.wait();
                                        }
                                        var6_7 = null;
                                        if (null == task) continue;
                                        task.abs_execute_time = this.counter = this.getTime();
                                        if (this.removeExecutingTask) break block26;
                                        this.insertSorted(task);
                                        break block27;
                                    }
                                    this.executingTask = task.obj;
                                    this.counter = this.getTime();
                                    long sleepingTime = task.abs_execute_time - this.counter;
                                    if (sleepingTime > 0L) {
                                        try {
                                            _logger.log(Level.FINE, "Current time=" + (int)(this.counter / 1000L) + ", Sleeping for " + sleepingTime + " msec.");
                                            Thread.sleep(sleepingTime);
                                        }
                                        catch (InterruptedException ieInner) {
                                            _logger.log(Level.FINE, "PeriodicEventScheduler::run() > " + ieInner);
                                        }
                                    } else {
                                        if (!task.obj.getExecutionTolerance(Math.abs(sleepingTime))) {
                                            _logger.log(Level.FINE, "Missed scheduling for " + ((Object)task.obj).toString());
                                            break block28;
                                        }
                                        _logger.log(Level.FINE, "Executing after missing scheduling for " + ((Object)task.obj).toString());
                                    }
                                    task.obj.service();
                                    break block29;
                                }
                                catch (InterruptedException ieOuter) {
                                    _logger.log(Level.FINE, "PeriodicEventScheduler::run() > " + ieOuter);
                                    var6_7 = null;
                                    if (null == task) continue;
                                    task.abs_execute_time = this.counter = this.getTime();
                                    if (!this.removeExecutingTask) {
                                        this.insertSorted(task);
                                    } else {
                                        this.removeExecutingTask = false;
                                    }
                                    this.executingTask = null;
                                    continue;
                                }
                                catch (Exception e) {
                                    System.out.println("PeriodicEventScheduler::run() > " + e);
                                    _logger.log(Level.WARNING, "iplanet_util.generic_exception", e);
                                    var6_7 = null;
                                    if (null == task) continue;
                                    task.abs_execute_time = this.counter = this.getTime();
                                    if (!this.removeExecutingTask) {
                                        this.insertSorted(task);
                                    } else {
                                        this.removeExecutingTask = false;
                                    }
                                    this.executingTask = null;
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                var6_7 = null;
                                if (null != task) {
                                    task.abs_execute_time = this.counter = this.getTime();
                                    if (!this.removeExecutingTask) {
                                        this.insertSorted(task);
                                    } else {
                                        this.removeExecutingTask = false;
                                    }
                                    this.executingTask = null;
                                }
                                throw throwable;
                            }
                        }
                        this.removeExecutingTask = false;
                    }
                    this.executingTask = null;
                    continue;
                }
                var6_7 = null;
                if (null == task) continue;
                task.abs_execute_time = this.counter = this.getTime();
                if (!this.removeExecutingTask) {
                    this.insertSorted(task);
                } else {
                    this.removeExecutingTask = false;
                }
                this.executingTask = null;
                continue;
            }
            var6_7 = null;
            if (null == task) continue;
            task.abs_execute_time = this.counter = this.getTime();
            if (!this.removeExecutingTask) {
                this.insertSorted(task);
            } else {
                this.removeExecutingTask = false;
            }
            this.executingTask = null;
        }
    }

    public String toString() {
        return "[PeriodicEventScheduler: " + this.sortedList.toString() + "]";
    }

    static {
        _instance = new PeriodicEventScheduler();
    }
}

