/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.pool;

import java.util.Properties;

public class PoolProperties {
    public static final String FACTORY_CLASS_NAME = "pool.factory.class";
    public static final String MINIMUM_SIZE = "pool.minsize";
    public static final String INITIAL_SIZE = "pool.initialsize";
    public static final String LOW_WATER_MARK = "pool.lowwatermark";
    public static final String HI_WATER_MARK = "pool.hiwatermark";
    public static final String MAX_STRONG_REFERENCES = "pool.maxstrongrefs";
    public static final String POOL_LIMIT = "pool.limit";
    public static final String MAX_IDLE_TIME = "pool.maxidletime";
    public long key;
    public String factoryClassName;
    public int minimumSize;
    public int initialSize;
    public int lowWaterMark;
    public int hiWaterMark;
    public int maxStrongRefs;
    public int poolLimit;
    public long maxIdleTime;

    public PoolProperties() {
    }

    public PoolProperties(int minimumSize, int poolLimit) {
        this.minimumSize = minimumSize;
        this.poolLimit = poolLimit;
    }

    public PoolProperties(Properties props) {
        this.factoryClassName = props.getProperty(FACTORY_CLASS_NAME);
        this.minimumSize = this.getIntProperty(props, MINIMUM_SIZE, 0);
        this.initialSize = this.getIntProperty(props, INITIAL_SIZE, 0);
        this.lowWaterMark = this.getIntProperty(props, LOW_WATER_MARK, 0);
        this.hiWaterMark = this.getIntProperty(props, HI_WATER_MARK, 0);
        this.poolLimit = this.getIntProperty(props, POOL_LIMIT, 0);
        this.maxIdleTime = this.getLongProperty(props, MAX_IDLE_TIME, 60000L);
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public void setFactoryClassName(String name) {
        this.factoryClassName = name;
    }

    public int getMinimumSize() {
        return this.minimumSize;
    }

    public void setMinimumSize(int val) {
        this.minimumSize = val;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int val) {
        this.initialSize = val;
    }

    public int getLowWaterMark() {
        return this.lowWaterMark;
    }

    public void setLowWaterMark(int val) {
        this.lowWaterMark = val;
    }

    public int getHiWaterMark() {
        return this.hiWaterMark;
    }

    public void setHiWaterMark(int val) {
        this.hiWaterMark = val;
    }

    public int getMaxStrongRefs() {
        return this.maxStrongRefs;
    }

    public void setMaxStrongRefs(int val) {
        this.maxStrongRefs = val;
    }

    public int getPoolLimit() {
        return this.poolLimit;
    }

    public void setPoolLimit(int val) {
        this.poolLimit = val;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(long val) {
        this.maxIdleTime = val;
    }

    private int getIntProperty(Properties props, String name, int defaultValue) {
        try {
            return Integer.parseInt(props.getProperty(name));
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    private long getLongProperty(Properties props, String name, long defaultValue) {
        try {
            return Long.parseLong(props.getProperty(name));
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("key: ").append(this.key).append("; min: ").append(this.minimumSize).append("; init: ").append(this.initialSize).append("; lowWM: ").append(this.lowWaterMark).append("; hiWM: ").append(this.hiWaterMark).append("; maxSRefs: ").append(this.maxStrongRefs).append("; limit: ").append(this.poolLimit);
        return sbuf.toString();
    }
}

