/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.net;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.StringTokenizer;

public class NetUtils {
    public static final int MAX_PORT = 65535;
    private static final String LOCALHOST_IP = "127.0.0.1";

    private NetUtils() {
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCanonicalHostName() throws UnknownHostException {
        String hostname = null;
        String defaultHostname = InetAddress.getLocalHost().getHostName();
        hostname = InetAddress.getLocalHost().getCanonicalHostName();
        if (hostname.equals(InetAddress.getLocalHost().getHostAddress()) || !hostname.startsWith(defaultHostname)) {
            hostname = defaultHostname;
        }
        return hostname;
    }

    public static InetAddress[] getHostAddresses() {
        try {
            String hname = NetUtils.getHostName();
            if (hname == null) {
                return null;
            }
            return InetAddress.getAllByName(hname);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String[] getHostIPs() {
        try {
            InetAddress[] adds = NetUtils.getHostAddresses();
            if (adds == null) {
                return null;
            }
            String[] ips = new String[adds.length];
            for (int i = 0; i < adds.length; ++i) {
                String ip;
                ips[i] = ip = NetUtils.trimIP(adds[i].toString());
            }
            return ips;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String trimIP(String ip) {
        if (ip == null || ip.length() <= 0) {
            return ip;
        }
        int index = ip.lastIndexOf(47);
        if (index >= 0) {
            return ip.substring(++index);
        }
        return ip;
    }

    public static byte[] ip2bytes(String ip) {
        try {
            ip = NetUtils.trimIP(ip);
            StringTokenizer stk = new StringTokenizer(ip, ".");
            byte[] bytes = new byte[stk.countTokens()];
            int i = 0;
            while (stk.hasMoreTokens()) {
                String num = stk.nextToken();
                int inum = Integer.parseInt(num);
                bytes[i] = (byte)inum;
                ++i;
            }
            return bytes;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static boolean isLocalHost(String ip) {
        if (ip == null) {
            return false;
        }
        ip = NetUtils.trimIP(ip);
        return ip.equals(LOCALHOST_IP);
    }

    public static boolean isLocal(String ip) {
        if (ip == null) {
            return false;
        }
        if (NetUtils.isLocalHost(ip = NetUtils.trimIP(ip))) {
            return true;
        }
        String[] myIPs = NetUtils.getHostIPs();
        if (myIPs == null) {
            return false;
        }
        for (int i = 0; i < myIPs.length; ++i) {
            if (!ip.equals(myIPs[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isRemote(String ip) {
        return !NetUtils.isLocal(ip);
    }

    public static int getNextFreePort(String hostName, int port) {
        while (port++ < 65535) {
            if (!NetUtils.isPortFree(hostName, port)) continue;
            return port;
        }
        return 0;
    }

    public static int getFreePort(String hostName, int startingPort, int endingPort) {
        int port;
        block1: {
            int range = endingPort - startingPort;
            port = 0;
            if (range <= 0) break block1;
            Random r = new Random();
            while (!NetUtils.isPortFree(hostName, port = r.nextInt(range + 1) + startingPort)) {
            }
        }
        return port;
    }

    public static boolean isPortValid(int portNumber) {
        return portNumber >= 0 && portNumber <= 65535;
    }

    public static boolean isPortStringValid(String portNumber) {
        try {
            return NetUtils.isPortValid(Integer.parseInt(portNumber));
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public static boolean isPortFree(String hostName, int portNumber) {
        if (portNumber <= 0 || portNumber > 65535) {
            return false;
        }
        try {
            if (hostName == null) {
                hostName = NetUtils.getHostName();
            }
            Socket socket = new Socket(hostName, portNumber);
            OutputStream os = socket.getOutputStream();
            InputStream is = socket.getInputStream();
            os.close();
            os = null;
            is.close();
            is = null;
            socket.close();
            socket = null;
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    public static boolean isPortFree(int portNumber) {
        return NetUtils.isPortFree(null, portNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int getFreePort() {
        int freePort = 0;
        boolean portFound = false;
        ServerSocket serverSocket = null;
        Class clazz = NetUtils.class;
        synchronized (clazz) {
            block20: {
                block19: {
                    serverSocket = new ServerSocket(0);
                    freePort = serverSocket.getLocalPort();
                    portFound = true;
                    Object var6_4 = null;
                    if (portFound) break block19;
                    freePort = 0;
                }
                try {
                    if (serverSocket != null) {
                        serverSocket.close();
                        if (!serverSocket.isClosed()) {
                            throw new Exception("local exception ...");
                        }
                    }
                    break block20;
                }
                catch (Exception e2) {
                    freePort = 0;
                }
                break block20;
                {
                    catch (Exception e) {
                        Object var6_5 = null;
                        if (!portFound) {
                            freePort = 0;
                        }
                        try {
                            if (serverSocket != null) {
                                serverSocket.close();
                                if (!serverSocket.isClosed()) {
                                    throw new Exception("local exception ...");
                                }
                            }
                            break block20;
                        }
                        catch (Exception e2) {
                            freePort = 0;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (!portFound) {
                        freePort = 0;
                    }
                    try {
                        if (serverSocket != null) {
                            serverSocket.close();
                            if (!serverSocket.isClosed()) {
                                throw new Exception("local exception ...");
                            }
                        }
                    }
                    catch (Exception e2) {
                        freePort = 0;
                    }
                    throw throwable;
                }
            }
            return freePort;
        }
    }

    public static void main(String[] args) {
        System.out.println("80: " + NetUtils.isPortFree(80));
        System.out.println("777: " + NetUtils.isPortFree(777));
        System.out.println("8000: " + NetUtils.isPortFree(8000));
    }
}

