/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.io;

import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.io.IOLogger;
import com.sun.enterprise.util.io.NativeIOException;
import java.util.ResourceBundle;
import java.util.logging.Logger;

class NativeResults {
    private Logger logger = IOLogger.getLogger();
    private ResourceBundle rb = null;
    private static final String RESOURCE_BUNDLE = "com.sun.logging.enterprise.system.util.LogStrings";
    private String errorKey;
    private String unknownErrorKey;
    private String genericError;
    private String osString;
    private int id;
    private String resultString;
    private NativeIOException exception = null;

    NativeResults(int id) {
        this.id = id;
        this.initStrings();
        this.setResultString();
        this.setResultException();
    }

    String getResultString() {
        return this.resultString;
    }

    NativeIOException getResultException() {
        return this.exception;
    }

    private void setResultString() {
        if (this.rb == null) {
            this.resultString = this.genericError + this.id;
            return;
        }
        try {
            this.resultString = this.rb.getString(this.errorKey + this.id);
            return;
        }
        catch (Throwable t) {
            try {
                this.resultString = this.rb.getString(this.unknownErrorKey) + this.id;
                return;
            }
            catch (Throwable t2) {
                this.resultString = this.genericError + this.id;
                return;
            }
        }
    }

    void setResultException() {
        if (this.id != 0) {
            this.exception = new NativeIOException(this.resultString, this.id);
        }
    }

    private void initStrings() {
        try {
            this.rb = ResourceBundle.getBundle(RESOURCE_BUNDLE);
        }
        catch (Throwable t) {
            this.rb = null;
            this.logger.severe("Unable to get a ResourceBundle: com.sun.logging.enterprise.system.util.LogStrings");
        }
        this.osString = OS.isWindows() ? "Windows" : "UNIX";
        this.errorKey = "enterprise_util." + this.osString + ".error.";
        this.unknownErrorKey = this.errorKey + "unknown";
        this.genericError = "UNKNOWN " + this.osString + " Error returned.  Errno =";
    }

    public static void main(String[] args) {
        int[] errs = new int[]{0, 1, 2, 4, 5, 13, 14, 20, 22, 30, 67, 78, 9999, 111, -2};
        for (int i = 0; i < errs.length; ++i) {
            int id = errs[i];
            NativeResults nr = new NativeResults(id);
            String s = "ID: " + id + ",  ";
            s = nr.getResultException() == null ? s + "NO ERROR, " : s + "YES ERROR, ";
            s = s + nr.getResultString();
            System.out.println(s);
        }
    }
}

