/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.diagnostics;

import com.sun.enterprise.util.Assertion;
import com.sun.enterprise.util.diagnostics.CallerInfoException;
import com.sun.logging.LogDomains;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;

public class CallerInfo {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private String className;
    private String fileName;
    private String methodName;
    private int lineNumber;
    private final String badFormat = "Bad Format in stack dump line";
    private Vector ignoreVec = new Vector();
    private static Vector globalIgnoreVec = new Vector();

    public CallerInfo() throws CallerInfoException {
        this(null);
    }

    public CallerInfo(Object[] ignoreUsToo) throws CallerInfoException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        Throwable t = new Throwable();
        String me = this.getClass().getName() + ".";
        this.ignoreVec.addElement(me);
        if (ignoreUsToo != null) {
            for (int i = 0; i < ignoreUsToo.length; ++i) {
                this.ignoreVec.addElement(ignoreUsToo[i].getClass().getName() + ".");
            }
        }
        if (globalIgnoreVec.size() > 0) {
            Enumeration e = globalIgnoreVec.elements();
            while (e.hasMoreElements()) {
                this.ignoreVec.addElement(e.nextElement().getClass().getName() + ".");
            }
        }
        t.printStackTrace(pw);
        pw.flush();
        StringTokenizer st = new StringTokenizer(baos.toString(), "\n\r\t");
        if (st.countTokens() < 3) {
            throw new CallerInfoException("Expected at least 3 lines from the stack dump -- only saw " + st.countTokens() + " lines");
        }
        st.nextToken();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (this.ignoreVec(s)) continue;
            this.parseCallerInfo(s);
            return;
        }
        throw new CallerInfoException("Couldn't find a caller method");
    }

    public static void addToGlobalIgnore(Object o) {
        Enumeration e = globalIgnoreVec.elements();
        while (e.hasMoreElements()) {
            if (o != e.nextElement()) continue;
            return;
        }
        globalIgnoreVec.addElement(o);
    }

    void parseCallerInfo(String stackDumpLine) throws CallerInfoException {
        if (!stackDumpLine.startsWith("at ")) {
            throw new CallerInfoException("Bad Format in stack dump line -- no \"at \" at start of line (" + stackDumpLine + ")");
        }
        stackDumpLine = stackDumpLine.substring(3);
        String classInfo = this.parseAndRemoveLineInfo(stackDumpLine);
        this.parseClassInfo(classInfo);
    }

    public String getClassName() {
        Assertion.check(this.className);
        return this.className;
    }

    public String getFileName() {
        Assertion.check(this.fileName != null);
        return this.fileName;
    }

    public String getMethodName() {
        Assertion.check(this.methodName);
        return this.methodName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        Assertion.check(this.className);
        Assertion.check(this.methodName);
        Assertion.check(this.fileName != null);
        StringBuffer sb = new StringBuffer();
        sb.append(this.className);
        sb.append(".");
        sb.append(this.methodName);
        if (this.fileName.length() > 0) {
            sb.append("(" + this.fileName + ":" + this.lineNumber + ")");
        } else {
            sb.append("(Unknown Source");
        }
        return sb.toString();
    }

    public String toStringDebug() {
        Assertion.check(this.className);
        Assertion.check(this.methodName);
        Assertion.check(this.fileName != null);
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("  dump:");
        sb.append("\nClass Name: ");
        sb.append(this.className);
        sb.append("\nMethod Name: ");
        sb.append(this.methodName);
        sb.append("\nFile Name: ");
        if (this.fileName.length() > 0) {
            sb.append(this.fileName);
            sb.append("\nLine Number: ");
            sb.append(this.lineNumber);
        } else {
            sb.append("unknown");
        }
        return sb.toString();
    }

    private String parseAndRemoveLineInfo(String s) throws CallerInfoException {
        this.fileName = "";
        this.lineNumber = -1;
        int left = s.indexOf(40);
        int right = s.indexOf(41);
        if (left < 0 || right < 0 || right <= left) {
            throw new CallerInfoException("Bad Format in stack dump line -- no parenthesis in line:" + s);
        }
        String lineInfo = s.substring(left + 1, right);
        s = s.substring(0, left);
        if (lineInfo.length() <= 0) {
            return s;
        }
        if (lineInfo.equals("Unknown Source")) {
            return s;
        }
        int colon = lineInfo.indexOf(58);
        if (colon < 0) {
            this.fileName = lineInfo;
            return s;
        }
        if (colon == lineInfo.length() - 1) {
            this.fileName = lineInfo.substring(0, colon);
            return s;
        }
        this.fileName = lineInfo.substring(0, colon);
        try {
            this.lineNumber = Integer.parseInt(lineInfo.substring(colon + 1));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return s;
    }

    private void parseClassInfo(String s) throws CallerInfoException {
        if (s.indexOf(46) < 0) {
            throw new CallerInfoException("Bad Format in stack dump line -- no \".\" in the fully-qualified method name");
        }
        if (s.indexOf(46) == 0) {
            throw new CallerInfoException("Bad Format in stack dump line fully-qualified method name starts with a dot");
        }
        int index = s.lastIndexOf(46);
        this.className = s.substring(0, index);
        this.methodName = s.substring(index + 1);
    }

    private boolean ignoreVec(String s) {
        Assertion.check(this.ignoreVec);
        int size = this.ignoreVec.size();
        Assertion.check(size > 0);
        for (int i = 0; i < size; ++i) {
            if (s.indexOf((String)this.ignoreVec.elementAt(i)) < 0) continue;
            return true;
        }
        return false;
    }
}

