/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.cache.test;

import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HashtableTest {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private String[] keys;
    private int maxKeys;
    private int maxLoop;

    public HashtableTest(int maxKeys, int maxLoop) {
        this.maxKeys = maxKeys;
        this.maxLoop = maxLoop;
        this.keys = new String[maxKeys];
        for (int i = 0; i < maxKeys; ++i) {
            this.keys[i] = "" + i;
        }
    }

    public void testHashtable() {
        long t1 = 0L;
        long t2 = 0L;
        Hashtable<String, String> tab = new Hashtable<String, String>();
        for (int i = 0; i < this.maxKeys; ++i) {
            tab.put(this.keys[i], this.keys[i]);
        }
        double sum = 0.0;
        for (int j = 0; j < this.maxLoop; ++j) {
            t1 = System.currentTimeMillis();
            for (int i = this.maxKeys - 1; i > 0; --i) {
                String key = this.keys[i];
                if (tab.get(key).equals(key)) continue;
                _logger.log(Level.WARNING, "iplanet_util.lookup_fail", key);
            }
            t2 = System.currentTimeMillis();
            _logger.log(Level.FINE, "Hashtable lookup took: " + (double)(t2 - t1) / 1000.0 + " seconds.");
            sum += (double)(t2 - t1);
        }
        _logger.log(Level.FINE, "Average Hashtable lookup took: " + sum / (double)this.maxLoop / 1000.0 + " seconds.");
    }

    public static void main(String[] args) {
        HashtableTest test = new HashtableTest(200000, 10);
        test.testHashtable();
    }
}

