/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.cache;

import com.sun.enterprise.util.cache.Cache;
import com.sun.enterprise.util.cache.CacheEventListener;
import com.sun.enterprise.util.cache.CacheNode;
import com.sun.enterprise.util.cache.CacheStore;
import com.sun.enterprise.util.cache.CacheVictimSelector;
import com.sun.enterprise.util.scheduler.PeriodicEventScheduler;
import com.sun.enterprise.util.scheduler.PeriodicallyServicable;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleAssociativeCache
implements Cache,
PeriodicallyServicable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private int loWaterMark;
    private int hiWaterMark;
    CacheNode[] buckets;
    Object[] bucketLocks;
    int maxBuckets;
    CacheStore backupStore;
    CacheVictimSelector victimSelector;
    private int size;
    private PeriodicEventScheduler scheduler = PeriodicEventScheduler.getInstance();
    private boolean isSelectingVictims = false;
    private CacheEventListener container;
    private boolean debug = false;

    public SimpleAssociativeCache(int lowWaterMark, int highWaterMark, CacheStore store, CacheVictimSelector victimSelector) {
        this((int)((double)highWaterMark * 1.5), lowWaterMark, highWaterMark, store, victimSelector);
    }

    public SimpleAssociativeCache(int maxBuckets, int lowWaterMark, int highWaterMark, CacheStore store, CacheVictimSelector victimSelector) {
        this.buckets = new CacheNode[maxBuckets];
        this.bucketLocks = new Object[maxBuckets];
        this.maxBuckets = maxBuckets;
        for (int i = 0; i < maxBuckets; ++i) {
            this.buckets[i] = null;
            this.bucketLocks[i] = new Object();
        }
        this.backupStore = store;
        this.victimSelector = victimSelector;
        this.size = 0;
        this.loWaterMark = lowWaterMark;
        this.hiWaterMark = highWaterMark;
    }

    public boolean contains(Object key) {
        return this.getEntry(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getEntry(Object key) {
        CacheNode node;
        int keyHashCode = key.hashCode();
        int index = (Integer.MAX_VALUE & keyHashCode) % this.maxBuckets;
        Object object = this.bucketLocks[index];
        synchronized (object) {
            node = this.buckets[index];
            while (!(node == null || keyHashCode == node.keyHashCode && key.equals(node.key))) {
                node = node.next;
            }
        }
        if (node != null) {
            this.victimSelector.nodeAccessed(node);
            return node.object;
        }
        return this.load(key, keyHashCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putEntry(Object key, Object object) {
        CacheNode node;
        int keyHashCode = key.hashCode();
        int index = (Integer.MAX_VALUE & keyHashCode) % this.maxBuckets;
        Object oldObject = null;
        Object object2 = this.bucketLocks[index];
        synchronized (object2) {
            node = this.buckets[index];
            while (node != null) {
                if (keyHashCode == node.keyHashCode && key.equals(node.key)) {
                    oldObject = node.object;
                    node.object = object;
                    break;
                }
                node = node.next;
            }
            if (oldObject == null) {
                node = new CacheNode(key, keyHashCode, object);
                node.next = this.buckets[index];
                this.buckets[index] = node;
            }
        }
        if (oldObject != null) {
            this.victimSelector.nodeAccessed(node);
            return oldObject;
        }
        this.victimSelector.nodeCreated(node);
        object2 = this;
        synchronized (object2) {
            if (++this.size < this.hiWaterMark || this.isSelectingVictims) {
                return null;
            }
            this.isSelectingVictims = true;
        }
        _logger.log(Level.FINE, "Making room after adding key: " + key);
        this.makeRoom();
        _logger.log(Level.FINE, "New size of the cache = " + this.size);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeEntry(Object key) {
        int keyHashCode = key.hashCode();
        int index = (Integer.MAX_VALUE & keyHashCode) % this.maxBuckets;
        CacheNode prev = null;
        CacheNode node = null;
        Object object = this.bucketLocks[index];
        synchronized (object) {
            node = this.buckets[index];
            while (!(node == null || keyHashCode == node.keyHashCode && key.equals(node.key))) {
                prev = node;
                node = node.next;
            }
            if (node == null) {
                return this.backupStore.lookup(key);
            }
            if (prev == null) {
                this.buckets[index] = node.next;
            } else {
                prev.next = node.next;
            }
            node.next = null;
        }
        object = this;
        synchronized (object) {
            --this.size;
        }
        this.victimSelector.nodeRemoved(node);
        return node.object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator keys() {
        ArrayList<Object> keyList = new ArrayList<Object>();
        for (int index = 0; index < this.maxBuckets; ++index) {
            Object object = this.bucketLocks[index];
            synchronized (object) {
                CacheNode node = this.buckets[index];
                while (node != null) {
                    keyList.add(node.key);
                    node = node.next;
                }
                continue;
            }
        }
        return keyList.iterator();
    }

    private Object load(Object key, int keyHashCode) {
        Object object = this.backupStore.lookup(key);
        if (object == null) {
            return null;
        }
        this.putEntry(key, object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeRoom() {
        int removed = 0;
        _logger.log(Level.FINE, "Selecting: " + (this.size - this.loWaterMark) + " victims....");
        CacheNode[] victims = this.victimSelector.selectVictims(this.size - this.loWaterMark);
        CacheNode victimNode = null;
        int i = victims.length;
        while (i-- > 0) {
            victimNode = victims[i];
            if (this.container != null) {
                this.container.victimSelected(victimNode.object);
            }
            this.backupStore.store(victimNode.key, victimNode.object);
            int index = (Integer.MAX_VALUE & victimNode.keyHashCode) % this.maxBuckets;
            Object object = this.bucketLocks[index];
            synchronized (object) {
                CacheNode prev = null;
                CacheNode node = this.buckets[index];
                while (node != null) {
                    if (node == victimNode) {
                        _logger.log(Level.FINE, "Found node and removing it ");
                        if (prev == null) {
                            this.buckets[index].next = node.next;
                        } else {
                            prev.next = node.next;
                        }
                        node.object = null;
                        node.key = null;
                        ++removed;
                        break;
                    }
                    prev = node;
                    node = node.next;
                }
            }
        }
        SimpleAssociativeCache simpleAssociativeCache = this;
        synchronized (simpleAssociativeCache) {
            this.isSelectingVictims = false;
            this.size -= removed;
        }
    }

    public long getFrequency() {
        return 60000L;
    }

    public boolean getExecuteIfMissed() {
        return true;
    }

    public boolean getExecutionTolerance(long missedByMillis) {
        return true;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void prolog() {
    }

    public void service() {
        this.makeRoom();
    }

    public void epilog() {
    }

    public Object getLockForEntry(Object key) {
        int keyHashCode = key.hashCode();
        int index = (Integer.MAX_VALUE & keyHashCode) % this.maxBuckets;
        return this.bucketLocks[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator values() {
        ArrayList<Object> keyList = new ArrayList<Object>();
        for (int index = 0; index < this.maxBuckets; ++index) {
            Object object = this.bucketLocks[index];
            synchronized (object) {
                CacheNode node = this.buckets[index];
                while (node != null && node.object != null) {
                    keyList.add(node.object);
                    node = node.next;
                }
                continue;
            }
        }
        return keyList.iterator();
    }

    public void setCacheEventListener(CacheEventListener cacheListener) {
        this.container = cacheListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getKeyEntry(Object key, Object ejbObject) {
        CacheNode node;
        int keyHashCode = key.hashCode();
        int index = (Integer.MAX_VALUE & keyHashCode) % this.maxBuckets;
        Object object = this.bucketLocks[index];
        synchronized (object) {
            node = this.buckets[index];
            while (!(node == null || keyHashCode == node.keyHashCode && key.equals(node.key))) {
                node = node.next;
            }
        }
        if (node != null) {
            this.victimSelector.nodeAccessed(node);
            return node.object;
        }
        return this.load(key, keyHashCode, ejbObject);
    }

    private Object load(Object key, int keyHashCode, Object ejbObject) {
        Object object = this.backupStore.lookup(key);
        if (object == null) {
            return null;
        }
        if (this.container != null) {
            this.container.activate(key, object, ejbObject);
        }
        this.putEntry(key, object);
        return object;
    }
}

