/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.cache;

import com.sun.enterprise.util.ApproximateClock;
import com.sun.enterprise.util.cache.CacheNode;
import com.sun.enterprise.util.cache.CacheVictimSelector;
import com.sun.enterprise.util.collection.DList;
import com.sun.enterprise.util.collection.DListNode;
import java.util.ArrayList;

public class RandomVictimSelector
implements CacheVictimSelector {
    DList list = new DList();
    ApproximateClock clock = new ApproximateClock(60000L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeCreated(CacheNode node) {
        node.accessedAt = this.clock.getTime();
        DList dList = this.list;
        synchronized (dList) {
            node.accessData = this.list.addAsLastObject(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeAccessed(CacheNode node) {
        long lastAccessedAt = node.accessedAt;
        node.accessedAt = this.clock.getTime();
        if (node.accessedAt > lastAccessedAt) {
            DList dList = this.list;
            synchronized (dList) {
                DListNode listNode = (DListNode)node.accessData;
                this.list.delink(listNode);
                this.list.addAsLastNode(listNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeRemoved(CacheNode node) {
        DList dList = this.list;
        synchronized (dList) {
            this.list.delink((DListNode)node.accessData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheNode[] selectVictims(int count) {
        ArrayList<Object> victims = new ArrayList<Object>();
        DList dList = this.list;
        synchronized (dList) {
            while (this.list.size() > 0 && count > 0) {
                victims.add(this.list.removeFirstObject());
                --count;
            }
        }
        return victims.toArray(new CacheNode[0]);
    }
}

