/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.cache;

import com.sun.enterprise.util.cache.CacheStore;
import com.sun.enterprise.util.cache.ConcurrentMap;
import com.sun.enterprise.util.scheduler.PeriodicEventScheduler;
import com.sun.enterprise.util.scheduler.PeriodicallyServicable;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileCacheStore
implements CacheStore,
PeriodicallyServicable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private static final long MAX_UNUSED_TIME = 60000L;
    File dir;
    ConcurrentMap map;
    private boolean debug = false;

    public FileCacheStore(String directory) {
        try {
            this.dir = new File(directory);
            this.dir.mkdirs();
            this.map = new ConcurrentMap(1024);
            PeriodicEventScheduler scheduler = PeriodicEventScheduler.getInstance();
            _logger.log(Level.FINE, "Scheduler: " + scheduler);
            PeriodicEventScheduler.getInstance().addTimeRepeatableTask(this, 1);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "iplanet_util.fcstore_create_exception", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(Object key) {
        String fileName = (String)this.map.removeEntry(key);
        if (fileName == null) {
            return null;
        }
        File file = new File(this.dir, fileName);
        ObjectInputStream ois = null;
        try {
            Object object;
            _logger.log(Level.FINE, this.getClass() + ": inside lookup. File: " + file);
            if (!file.exists()) {
                _logger.log(Level.WARNING, "iplanet_util.lookup_warning", new Object[]{this.getClass(), key});
                Object var5_5 = null;
                return var5_5;
            }
            ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            Object object2 = object = ois.readObject();
            return object2;
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "iplanet_util.lookup_exception", ex);
        }
        finally {
            try {
                ois.close();
            }
            catch (IOException ioEx) {}
            file.delete();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Object key, Object object) {
        File file = null;
        try {
            String fileNameKey = "" + key;
            this.map.putEntry(key, fileNameKey);
            file = new File(this.dir, fileNameKey);
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            oos.writeObject(object);
            oos.close();
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "iplanet_util.store_exception", ex);
        }
        finally {
            file.deleteOnExit();
        }
    }

    public long getFrequency() {
        return 60000L;
    }

    public boolean getExecuteIfMissed() {
        return true;
    }

    public boolean getExecutionTolerance(long missedByMillis) {
        return true;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void prolog() {
    }

    public void service() {
        Iterator iter = this.map.keys();
        long minIdleTime = System.currentTimeMillis() - 60000L;
        while (iter.hasNext()) {
            Object key = iter.next();
            String fileName = (String)this.map.getEntry(key);
            File file = new File(this.dir, fileName);
            if (file.lastModified() >= minIdleTime) continue;
            this.map.removeEntry(key);
            file.delete();
        }
    }

    public void epilog() {
    }
}

