/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.cache;

import com.sun.enterprise.util.cache.Cache;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConcurrentMap
implements Cache {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private int maxBuckets = maxBuckets += 13;
    private CMapNode[] buckets;
    private Object[] bucketLocks;
    private int size;
    private boolean debug = false;

    public ConcurrentMap(int maxBuckets) {
        this.buckets = new CMapNode[maxBuckets];
        this.bucketLocks = new Object[maxBuckets];
        for (int i = 0; i < maxBuckets; ++i) {
            this.bucketLocks[i] = new Object();
        }
        this.size = 0;
    }

    public boolean contains(Object key) {
        return this.getEntry(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getEntry(Object key) {
        int keyHashCode = key.hashCode();
        int index = (keyHashCode & Integer.MAX_VALUE) % this.buckets.length;
        Object object = this.bucketLocks[index];
        synchronized (object) {
            CMapNode node = this.buckets[index];
            while (node != null) {
                if (node.keyHashCode == keyHashCode && node.key.equals(key)) {
                    return node.object;
                }
                node = node.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putEntry(Object key, Object object) {
        int keyHashCode = key.hashCode();
        int index = (Integer.MAX_VALUE & keyHashCode) % this.maxBuckets;
        Object oldObject = null;
        Object object2 = this.bucketLocks[index];
        synchronized (object2) {
            CMapNode node = this.buckets[index];
            while (node != null) {
                if (node.keyHashCode == keyHashCode && key.equals(node.key)) {
                    oldObject = node.object;
                    node.object = object;
                    return oldObject;
                }
                node = node.next;
            }
            this.buckets[index] = node = new CMapNode(key, keyHashCode, object, this.buckets[index]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeEntry(Object key) {
        int keyHashCode = key.hashCode();
        int index = (Integer.MAX_VALUE & keyHashCode) % this.maxBuckets;
        CMapNode prev = null;
        CMapNode node = null;
        Object object = this.bucketLocks[index];
        synchronized (object) {
            node = this.buckets[index];
            while (node != null) {
                if (node.keyHashCode == keyHashCode && key.equals(node.key)) {
                    if (prev == null) {
                        this.buckets[index] = node.next;
                    } else {
                        prev.next = node.next;
                    }
                    node.next = null;
                    return node.object;
                }
                prev = node;
                node = node.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator keys() {
        ArrayList<Object> keyList = new ArrayList<Object>();
        for (int index = 0; index < this.maxBuckets; ++index) {
            Object object = this.bucketLocks[index];
            synchronized (object) {
                CMapNode node = this.buckets[index];
                while (node != null) {
                    _logger.log(Level.FINE, "keys() :: Key: " + node.key);
                    keyList.add(node.key);
                    node = node.next;
                }
                continue;
            }
        }
        return keyList.iterator();
    }

    public String toString() {
        return this.getClass().getName();
    }

    private static class CMapNode {
        Object key;
        Object object;
        int keyHashCode;
        CMapNode next;

        CMapNode() {
        }

        CMapNode(Object key, int keyHashCode, Object object, CMapNode next) {
            this.key = key;
            this.object = object;
            this.keyHashCode = keyHashCode;
            this.next = next;
        }
    }
}

