/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.cache;

import com.sun.enterprise.util.cache.Bucket;
import com.sun.enterprise.util.cache.Cache;

public class BucketMap
implements Cache {
    private int maxBuckets;
    private Bucket[] buckets;
    private int size;

    public BucketMap(int maxBuckets) {
        this.maxBuckets = maxBuckets;
        this.buckets = new Bucket[maxBuckets];
        for (int i = 0; i < maxBuckets; ++i) {
            this.buckets[i] = new Bucket();
        }
        this.size = 0;
    }

    public Bucket getBucket(Object key) {
        int index = (Integer.MAX_VALUE & key.hashCode()) % this.maxBuckets;
        return this.buckets[index];
    }

    public Bucket getBucket(int keyHashCode) {
        return this.buckets[(Integer.MAX_VALUE & keyHashCode) % this.maxBuckets];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object key) {
        int keyHashCode = key.hashCode();
        int index = (Integer.MAX_VALUE & keyHashCode) % this.maxBuckets;
        Bucket bucket = this.buckets[index];
        synchronized (bucket) {
            return this.buckets[index].contains(key, keyHashCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getEntry(Object key) {
        int keyHashCode = key.hashCode();
        int index = (Integer.MAX_VALUE & keyHashCode) % this.maxBuckets;
        Bucket bucket = this.buckets[index];
        synchronized (bucket) {
            return this.buckets[index].getEntry(key, keyHashCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putEntry(Object key, Object object) {
        int keyHashCode = key.hashCode();
        int index = (Integer.MAX_VALUE & keyHashCode) % this.maxBuckets;
        Bucket bucket = this.buckets[index];
        synchronized (bucket) {
            return this.buckets[index].putEntry(key, object, keyHashCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeEntry(Object key) {
        int keyHashCode = key.hashCode();
        int index = (Integer.MAX_VALUE & keyHashCode) % this.maxBuckets;
        Bucket bucket = this.buckets[index];
        synchronized (bucket) {
            return this.buckets[index].removeEntry(key, keyHashCode);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

