/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApproximateClock
implements Runnable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private long sleepTime = 1000L;
    private long now;
    private Thread timerThread;
    private long[] time;
    private int index = 0;
    private int nextIndex;

    public ApproximateClock(long delay) {
        this.setDelay(delay);
        this.timerThread = new Thread((Runnable)this, "ApproximateClock");
        this.timerThread.setDaemon(true);
        this.time = new long[2];
        this.time[0] = System.currentTimeMillis();
        this.timerThread.start();
    }

    public long getActualTime() {
        this.nextIndex = 1 - this.index;
        this.time[this.nextIndex] = System.currentTimeMillis();
        this.index = this.nextIndex;
        return this.time[this.index];
    }

    public long getTime() {
        return this.time[this.index];
    }

    public void setDelay(long delay) {
        this.sleepTime = delay < 1L ? 1L : delay;
    }

    public long getDelay() {
        return this.sleepTime;
    }

    public final void run() {
        try {
            while (true) {
                this.getActualTime();
                Thread.sleep(this.sleepTime);
            }
        }
        catch (InterruptedException inEx) {
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        int count = 100000000;
        long time = 0L;
        long t1 = 0L;
        long t2 = 0L;
        t1 = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            time = System.currentTimeMillis();
        }
        t2 = System.currentTimeMillis();
        _logger.log(Level.FINE, "sys.currentTimeMillis() took: " + (double)(t2 - t1) / 1000.0 + " seconds " + time);
        t1 = System.currentTimeMillis();
        ApproximateClock clock = new ApproximateClock(3000L);
        for (int i = 0; i < count; ++i) {
            time = clock.getTime();
        }
        t2 = System.currentTimeMillis();
        _logger.log(Level.FINE, "clock.getTime() took: " + (double)(t2 - t1) / 1000.0 + " seconds " + time);
    }
}

