/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.monitor;

import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.BaseMonitorMBean;
import com.sun.enterprise.admin.monitor.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.JTAStats;
import com.sun.enterprise.admin.monitor.types.Counter;
import com.sun.enterprise.admin.monitor.types.MonitoredAttributeType;
import com.sun.enterprise.admin.monitor.types.StringMonitoredAttributeType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.TransactionService;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.transaction.TransactionAdminBean;
import com.sun.enterprise.transaction.monitor.JTAStatsImpl;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class JTSMonitorMBean
extends BaseMonitorMBean {
    static final String NUM_TRANSACTIONS_COMPLETED = "total-tx-completed";
    static final String NUM_TRANSACTIONS_ROLLEDBACK = "total-tx-rolled-back";
    static final String NUM_TRANSACTIONS_INFLIGHT = "total-tx-inflight";
    static final String IS_FROZEN = "isFrozen";
    static final String INFLIGHT_TRANSACTIONS = "inflight-tx";
    static final String ROLLBACK = "rollbackList";
    static final String FREEZE = "freeze";
    static final int COLUMN_LENGTH = 25;
    private static StringManager sm = StringManager.getManager(JTSMonitorMBean.class);
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jta");
    private static Object[][] attrNameTypeArray = new Object[][]{{"total-tx-completed", Counter.INTEGER}, {"total-tx-rolled-back", Counter.INTEGER}, {"total-tx-inflight", Counter.INTEGER}, {"isFrozen", StringMonitoredAttributeType.DEFAULT}, {"inflight-tx", StringMonitoredAttributeType.DEFAULT}};
    private static MBeanOperationInfo[] operationInfoArray = new MBeanOperationInfo[2];
    private J2EETransactionManager txnMgr;
    private Hashtable txnTable = null;
    private MonitoredObjectType type = MonitoredObjectType.TXNMGR;
    private boolean monitorOn = false;
    private long startTime = 0L;
    private static Map attrNameTypeMap = JTSMonitorMBean.createAttrNameTypeMap(attrNameTypeArray);
    private static MBeanInfo mBeanInfo;

    public JTSMonitorMBean() {
        this.txnMgr = Switch.getSwitch().getTransactionManager();
        ServerContext sCtx = ApplicationServer.getServerContext();
        if (sCtx != null) {
            try {
                ConfigContext ctx = sCtx.getConfigContext();
                Config cfg = ServerBeansFactory.getConfigBean(ctx);
                String lvl = cfg.getMonitoringService().getModuleMonitoringLevels().getTransactionService();
                MonitoringLevel l = MonitoringLevel.instance((String)lvl);
                if (l != MonitoringLevel.OFF) {
                    this.startMonitoring();
                }
                MonitoringRegistry registry = sCtx.getMonitoringRegistry();
                JTAStatsImpl.createInstance(this);
                JTAStatsImpl statImpl = JTAStatsImpl.getInstance();
                registry.registerJTAStats((JTAStats)statImpl, (MonitoringLevelListener)statImpl);
                _logger.log(Level.FINE, "JTAStats monitoring registration completed");
                TransactionService txnService = ServerBeansFactory.getTransactionServiceBean(ctx);
                ElementProperty[] eprops = txnService.getElementProperty();
                for (int index = 0; index < eprops.length; ++index) {
                    if (!"pending-txn-cleanup-interval".equals(eprops[index].getName())) continue;
                    int interval = 60;
                    if (eprops[index].getValue() != null) {
                        interval = Integer.parseInt(eprops[index].getValue());
                    }
                    new RecoveryHelperThread(interval).start();
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "Asynchronous thread for incomplete tx is enabled with interval " + interval);
                }
            }
            catch (MonitoringRegistrationException mex) {
                _logger.log(Level.WARNING, "transaction.monitor.registration_failed", mex);
            }
            catch (ConfigException e) {
                _logger.log(Level.WARNING, "transaction.monitor.registration_failed", e);
            }
        } else {
            _logger.log(Level.FINE, "JTSMonitorMBean: ServerContext is null: monitoring is not enabled");
        }
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("transaction.monitor.attribute_is_null")));
        }
        if (attribute.equals(NUM_TRANSACTIONS_COMPLETED)) {
            return new Integer(this.txnMgr.getNumberOfTransactionsCommitted());
        }
        if (attribute.equals(NUM_TRANSACTIONS_ROLLEDBACK)) {
            return new Integer(this.txnMgr.getNumberOfTransactionsRolledBack());
        }
        if (attribute.equals(NUM_TRANSACTIONS_INFLIGHT)) {
            return new Integer(this.txnMgr.getNumberOfActiveTransactions());
        }
        if (attribute.equals(IS_FROZEN)) {
            if (this.txnMgr.isFrozen()) {
                return "True";
            }
            return "False";
        }
        if (attribute.equals(INFLIGHT_TRANSACTIONS)) {
            ArrayList aList = this.txnMgr.getActiveTransactions();
            if (aList.isEmpty()) {
                return "";
            }
            StringBuffer strBuf = new StringBuffer(1024);
            this.txnTable = new Hashtable();
            if (aList.size() > 0) {
                int i;
                String colName = "Transaction Id";
                strBuf.append("\n\n");
                strBuf.append(colName);
                for (i = colName.length(); i < 40; ++i) {
                    strBuf.append(" ");
                }
                colName = "Status";
                strBuf.append(colName);
                for (i = colName.length(); i < 25; ++i) {
                    strBuf.append(" ");
                }
                strBuf.append("ElapsedTime(ms)\n");
            }
            for (int i = 0; i < aList.size(); ++i) {
                int j;
                TransactionAdminBean txnBean = (TransactionAdminBean)aList.get(i);
                Transaction j2eeTxn = (Transaction)txnBean.getIdentifier();
                String txnId = txnBean.getId();
                this.txnTable.put(txnId, j2eeTxn);
                strBuf.append("\n");
                strBuf.append(txnId);
                for (j = txnId.length(); j < 40; ++j) {
                    strBuf.append(" ");
                }
                strBuf.append(txnBean.getStatus());
                for (j = txnBean.getStatus().length(); j < 25; ++j) {
                    strBuf.append(" ");
                }
                strBuf.append(String.valueOf(txnBean.getElapsedTime()));
            }
            return strBuf.toString();
        }
        throw new AttributeNotFoundException(sm.getString("transaction.monitor.attribute_not_found", attribute));
    }

    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("transaction.monitor.attributes_not_null")));
        }
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                Object value = this.getAttribute(attributeNames[i]);
                resultList.add(new Attribute(attributeNames[i], value));
                continue;
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "transaction.monitor.error_while_getting_monitor_attr", e);
            }
        }
        return resultList;
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName == null || operationName.equals("")) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("transaction.monitor.operation_name_is_null")));
        }
        if (params == null) {
            return null;
        }
        AttributeList resultList = new AttributeList();
        if (operationName.equals(ROLLBACK)) {
            for (int i = 0; i < params.length; ++i) {
                String txnId = (String)params[i];
                Object value = this.setRollback(txnId);
                resultList.add(new Attribute(txnId, value));
            }
        } else if (operationName.equals(FREEZE)) {
            if (params[0].equals("true")) {
                this.txnMgr.freeze();
                resultList.add(new Attribute(FREEZE, "Successful"));
            } else {
                this.txnMgr.unfreeze();
                resultList.add(new Attribute("unfreeze", "Successful"));
            }
        } else {
            throw new UnsupportedOperationException(UNSUPPORTED_ERRMSG);
        }
        return resultList;
    }

    public void freeze() {
        this.txnMgr.freeze();
    }

    public void unfreeze() {
        this.txnMgr.unfreeze();
    }

    public String[] rollback(String[] txnIds) {
        if (txnIds == null || txnIds.length == 0) {
            return new String[0];
        }
        String[] result = new String[txnIds.length];
        for (int i = 0; i < txnIds.length; ++i) {
            result[i] = (String)this.setRollback(txnIds[i]);
        }
        return result;
    }

    public Object setRollback(String txnId) throws IllegalStateException {
        String result = "";
        if (this.txnTable == null || this.txnTable.get(txnId) == null) {
            result = sm.getString("transaction.monitor.rollback_invalid_id");
            throw new IllegalStateException(result);
        }
        try {
            this.txnMgr.forceRollback((Transaction)this.txnTable.get(txnId));
            result = sm.getString("transaction.monitor.rollback_sucessful");
        }
        catch (IllegalStateException e) {
            result = sm.getString("transaction.monitor.rollback_unsuccessful_not_associated");
            IllegalStateException ex = new IllegalStateException(result);
            ex.initCause(e);
            throw ex;
        }
        catch (SecurityException e) {
            result = sm.getString("transaction.monitor.rollback_unsuccessful_security_exception");
            SecurityException ex = new SecurityException(result);
            ex.initCause(e);
            throw ex;
        }
        catch (SystemException e) {
            result = sm.getString("transaction.monitor.rollback_unsuccessful_unexpected_exception");
            IllegalStateException ex = new IllegalStateException(result);
            ex.initCause(e);
            throw ex;
        }
        return result;
    }

    public void startMonitoring() {
        this.txnMgr.setMonitoringEnabled(true);
        this.monitorOn = true;
        this.startTime = System.currentTimeMillis();
    }

    public void stopMonitoring() {
        this.txnMgr.setMonitoringEnabled(false);
        this.monitorOn = false;
        this.startTime = 0L;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public MBeanInfo getMBeanInfo() {
        return mBeanInfo;
    }

    public Map getMonitoringMetaData() {
        return attrNameTypeMap;
    }

    public MonitoredAttributeType getAttributeType(String attrName) {
        MonitoredAttributeType type = null;
        if (attrNameTypeMap != null && attrName != null) {
            type = (MonitoredAttributeType)attrNameTypeMap.get(attrName);
        }
        return type;
    }

    public MonitoredObjectType getMonitoredObjectType() {
        return this.type;
    }

    public static void recover(boolean delegated, String txLogDir) throws Exception {
        ResourceInstaller resInstaller = Switch.getSwitch().getResourceInstaller();
        boolean result = true;
        if (resInstaller == null) {
            throw new IllegalStateException();
        }
        result = !delegated ? resInstaller.recoverIncompleteTx(false, null) : resInstaller.recoverIncompleteTx(true, txLogDir);
        if (!result) {
            throw new IllegalStateException();
        }
    }

    static {
        JTSMonitorMBean.operationInfoArray[0] = new MBeanOperationInfo(ROLLBACK, "rollback(String txnId): Marks the transaction for rollback", null, "void", 1);
        JTSMonitorMBean.operationInfoArray[1] = new MBeanOperationInfo(FREEZE, "freeze(): Freezes the transactions", null, "void", 1);
        mBeanInfo = JTSMonitorMBean.createMBeanInfo(attrNameTypeMap, operationInfoArray);
    }

    class RecoveryHelperThread
    extends Thread {
        private int interval;

        RecoveryHelperThread(int interval) {
            this.setName("Recovery Helper Thread");
            this.setDaemon(true);
            this.interval = interval;
        }

        public void run() {
            try {
                while (true) {
                    Thread.sleep(this.interval * 1000);
                    Switch.getSwitch().getResourceInstaller().recoverIncompleteTx(false, null);
                }
            }
            catch (Exception ex) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, " Exception occurred in recoverInCompleteTx ");
                }
                return;
            }
        }
    }
}

