/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.webservices;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.JarCheck;
import com.sun.enterprise.tools.verifier.Result;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class WebServiceCheckMgrImpl
extends CheckMgr
implements JarCheck {
    private final String testsListFileName = "TestNamesWebServices.xml";
    private final String sunONETestsListFileName = WebServiceCheckMgrImpl.getSunPrefix().concat("TestNamesWebServices.xml");
    private Vector test = new Vector();
    private String moduleName;

    public WebServiceCheckMgrImpl(FrameworkContext frameworkContext) {
        this.frameworkContext = frameworkContext;
    }

    public void check(Descriptor descriptor) throws Exception {
        WebServicesDescriptor rootDescriptor = (WebServicesDescriptor)descriptor;
        ModuleType moduleType = rootDescriptor.getBundleDescriptor().getModuleType();
        if (moduleType == ModuleType.EJB) {
            this.moduleName = "ejb";
        } else if (moduleType == ModuleType.WAR) {
            this.moduleName = "web";
        }
        Iterator itr = rootDescriptor.getWebServices().iterator();
        while (itr.hasNext()) {
            WebService wsDescriptor = (WebService)itr.next();
            Iterator endPtItr = wsDescriptor.getEndpoints().iterator();
            while (endPtItr.hasNext()) {
                super.check((WebServiceEndpoint)endPtItr.next());
            }
        }
    }

    protected String getTestsListFileName() {
        return "TestNamesWebServices.xml";
    }

    protected String getSunONETestsListFileName() {
        return this.sunONETestsListFileName;
    }

    protected Vector getTests() {
        return this.test;
    }

    protected void loadTestInformationFromPropsFile() throws ParserConfigurationException, SAXException, IOException {
        Vector v = this.getTests();
        if (v.isEmpty()) {
            super.loadTestInformationFromPropsFile();
        }
    }

    protected String getArchiveUri(Descriptor descriptor) {
        String archiveUri = new File(((WebServiceEndpoint)descriptor).getBundleDescriptor().getModuleDescriptor().getArchiveUri()).getName();
        return archiveUri;
    }

    protected String getSpecVersion(Descriptor descriptor) {
        return ((WebServiceEndpoint)descriptor).getBundleDescriptor().getSpecVersion();
    }

    protected void setModuleName(Result r) {
        r.setModuleName(this.moduleName);
    }
}

