/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.web;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.BaseVerifier;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoaderFactory;
import com.sun.enterprise.tools.verifier.apiscan.packaging.ClassPathBuilder;
import com.sun.enterprise.tools.verifier.apiscan.stdapis.WebClosureCompiler;
import com.sun.enterprise.tools.verifier.web.WebCheckMgrImpl;
import com.sun.enterprise.util.JarClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class WebVerifier
extends BaseVerifier {
    private WebBundleDescriptor webd = null;
    private String classPath;
    private File jspOutDir = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WebVerifier(FrameworkContext frameworkContext, WebBundleDescriptor webd) {
        this.frameworkContext = frameworkContext;
        this.webd = webd;
        this.jspOutDir = this.getJspOutDir();
    }

    public void verify() throws Exception {
        if (this.areTestsNotRequired(this.frameworkContext.isWeb())) {
            return;
        }
        this.preVerification();
        this.context.setOutDir(this.jspOutDir);
        this.createClosureCompiler();
        this.verify(this.webd, new WebCheckMgrImpl(this.frameworkContext));
    }

    public Descriptor getDescriptor() {
        return this.webd;
    }

    protected ClassLoader createClassLoader(File explodedArchive) throws IOException {
        JarClassLoader cl = new JarClassLoader();
        StringTokenizer st = new StringTokenizer(this.getClassPath(), File.pathSeparator);
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            try {
                cl.appendURL(new File(entry).toURL());
            }
            catch (MalformedURLException e) {
                LogRecord log = new LogRecord(Level.WARNING, "Ignoring " + entry);
                log.setThrown(e);
                this.frameworkContext.getResultManager().log(log);
            }
        }
        this.webd.setClassLoader(cl);
        return cl;
    }

    protected String getArchiveUri() {
        return new File(this.webd.getModuleDescriptor().getArchiveUri()).getName();
    }

    protected String[] getDDString() {
        String[] dd = new String[]{"WEB-INF/sun-web.xml", "WEB-INF/web.xml", "WEB-INF/webservices.xml"};
        return dd;
    }

    protected String getClassPath() throws IOException {
        String cp;
        if (this.classPath != null) {
            return this.classPath;
        }
        if (!this.webd.getModuleDescriptor().isStandalone()) {
            String ear_uri = this.frameworkContext.getExplodedArchivePath();
            File ear = new File(ear_uri);
            if (!$assertionsDisabled && !ear.isDirectory()) {
                throw new AssertionError();
            }
            String earCP = ClassPathBuilder.buildClassPathForEar(ear);
            String module_uri = this.webd.getModuleDescriptor().getArchiveUri();
            File module = new File(module_uri);
            if (!($assertionsDisabled || module.isFile() && !module.isAbsolute())) {
                throw new AssertionError();
            }
            File explodedModuleDir = new File(ear_uri, module_uri.replaceAll("\\.", "_"));
            String moduleCP = ClassPathBuilder.buildClassPathForWar(explodedModuleDir);
            cp = moduleCP + File.pathSeparator + earCP;
        } else {
            String module_uri = this.frameworkContext.getExplodedArchivePath();
            File module = new File(module_uri);
            if (!($assertionsDisabled || module.isDirectory() && module.isAbsolute())) {
                throw new AssertionError();
            }
            cp = ClassPathBuilder.buildClassPathForWar(module);
        }
        cp = cp + File.pathSeparator + this.jspOutDir.getAbsolutePath();
        this.logger.log(Level.INFO, "Using CLASSPATH " + cp);
        this.classPath = cp;
        return this.classPath;
    }

    protected void createClosureCompiler() throws IOException {
        String specVer = this.webd.getSpecVersion();
        String cp = this.getClassPath();
        WebClosureCompiler cc = new WebClosureCompiler(specVer, ClassFileLoaderFactory.newInstance(new Object[]{cp}));
        this.context.setClosureCompiler(cc);
    }

    private File getJspOutDir() {
        float f;
        String outDirPath;
        File out;
        Random random = new Random();
        String prefix = System.getProperty("java.io.tmpdir") + File.separator + ".vc";
        do {
            f = random.nextFloat();
        } while (!(out = new File(outDirPath = new String(prefix + f))).mkdirs());
        out.deleteOnExit();
        return out;
    }

    static {
        $assertionsDisabled = !WebVerifier.class.desiredAssertionStatus();
    }
}

