/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.web;

import com.sun.enterprise.tools.verifier.TagLibDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public abstract class TagLibDescriptorImpl
implements TagLibDescriptor {
    protected Document doc = null;
    protected String version = null;
    protected String uri = null;

    public TagLibDescriptorImpl(Document doc, String version, String uri) {
        this.doc = doc;
        this.version = version;
        this.uri = uri;
    }

    public String getSpecVersion() {
        return this.version;
    }

    public String getUri() {
        return this.uri;
    }

    public String[] getTaglibClasses() {
        NodeList nl = this.doc.getElementsByTagName("tag-class");
        if (nl != null) {
            int size = nl.getLength();
            String[] tagClasses = new String[size];
            for (int i = 0; i < size; ++i) {
                tagClasses[i] = nl.item(i).getFirstChild().getNodeValue();
            }
            return tagClasses;
        }
        return null;
    }

    public String getTEIClass() {
        NodeList nl = this.doc.getElementsByTagName("tei-class");
        if (nl != null && nl.getLength() != 0) {
            String teiClass = nl.item(0).getFirstChild().getNodeValue();
            return teiClass;
        }
        return null;
    }

    public String[] getNamesFromTagElement() {
        NodeList tags = this.doc.getElementsByTagName("tag");
        int size = tags.getLength();
        String[] names = new String[size];
        if (size != 0) {
            for (int i = 0; i < size; ++i) {
                NodeList nl = tags.item(i).getChildNodes();
                boolean found = false;
                int k = 0;
                while (!found) {
                    if (nl.item(k).getNodeName().equalsIgnoreCase("name")) {
                        found = true;
                        names[i] = nl.item(k).getFirstChild() != null && !nl.item(k).getFirstChild().getNodeValue().trim().equals("") ? nl.item(k).getFirstChild().getNodeValue() : null;
                    }
                    ++k;
                }
            }
        } else {
            return null;
        }
        return names;
    }
}

