/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.wsclients;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.wsclients.WSClientCheck;
import com.sun.enterprise.tools.verifier.tests.wsclients.WSClientTest;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class PortComponentLinkValidCheck
extends WSClientTest
implements WSClientCheck {
    public Result check(ServiceReferenceDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        boolean pass = true;
        Set ports = descriptor.getPortsInfo();
        Iterator it = ports.iterator();
        while (it.hasNext()) {
            ServiceRefPortInfo ref = (ServiceRefPortInfo)it.next();
            if (!ref.hasPortComponentLinkName()) {
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notapp", "Not applicable since port-comp-link does not exist in port-comp-ref [{0}].", new Object[]{ref.getName()}));
                continue;
            }
            if (ref.getPortComponentLink() != null) {
                pass = true;
                continue;
            }
            if (this.isLinkValid(ref)) continue;
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Invalid port-component-link [{0}] in WebService client [{1}].", new Object[]{ref.getPortComponentLinkName(), compName.toString()}));
            pass = false;
        }
        if (pass) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "All port-component-link(s) in this service reference are valid."));
        }
        return result;
    }

    private boolean isLinkValid(ServiceRefPortInfo ref) {
        boolean pass = true;
        RootDeploymentDescriptor application = null;
        WebServiceEndpoint port = null;
        String linkName = ref.getPortComponentLinkName();
        application = this.getApplication();
        if (linkName != null && linkName.length() > 0 && application != null) {
            int hashIndex = linkName.indexOf(35);
            String relativeModuleUri = linkName.substring(0, hashIndex);
            String portName = linkName.substring(hashIndex + 1);
            Set<RootDeploymentDescriptor> ejbBundles = null;
            Set webBundles = null;
            if (application instanceof EjbBundleDescriptor) {
                ejbBundles = new HashSet<RootDeploymentDescriptor>();
                ejbBundles.add(application);
            } else if (application instanceof WebBundleDescriptor) {
                webBundles = ((Application)application).getWebBundleDescriptors();
            } else {
                webBundles = ((Application)application).getWebBundleDescriptors();
                ejbBundles = ((Application)application).getEjbBundleDescriptors();
            }
            Iterator ejbBundlesIterator = ejbBundles.iterator();
            EjbBundleDescriptor ejbBundle = null;
            while (ejbBundlesIterator.hasNext()) {
                ejbBundle = (EjbBundleDescriptor)ejbBundlesIterator.next();
                try {
                    String archiveuri = ejbBundle.getModuleDescriptor().getArchiveUri();
                    if (!relativeModuleUri.equals(archiveuri)) continue;
                    LinkedList<EjbBundleDescriptor> bundles = new LinkedList<EjbBundleDescriptor>();
                    bundles.addFirst(ejbBundle);
                    Iterator iter = bundles.iterator();
                    while (iter.hasNext()) {
                        BundleDescriptor next = (BundleDescriptor)iter.next();
                        port = next.getWebServiceEndpointByName(portName);
                        if (port == null) continue;
                        pass = true;
                    }
                }
                catch (Exception e) {}
            }
            Iterator webBundlesIterator = webBundles.iterator();
            WebBundleDescriptor webBundle = null;
            while (webBundlesIterator.hasNext()) {
                webBundle = (WebBundleDescriptor)webBundlesIterator.next();
                try {
                    String archiveuri = webBundle.getModuleDescriptor().getArchiveUri();
                    if (!relativeModuleUri.equals(archiveuri)) continue;
                    LinkedList<WebBundleDescriptor> bundles = new LinkedList<WebBundleDescriptor>();
                    bundles.addFirst(webBundle);
                    Iterator iter = bundles.iterator();
                    while (iter.hasNext()) {
                        BundleDescriptor next = (BundleDescriptor)iter.next();
                        port = next.getWebServiceEndpointByName(portName);
                        if (port == null) continue;
                        pass = true;
                    }
                }
                catch (Exception e) {}
            }
        }
        if (port == null) {
            pass = false;
        }
        return pass;
    }

    private RootDeploymentDescriptor getApplication() {
        AbstractArchive arch = null;
        Archivist archivist1 = null;
        RootDeploymentDescriptor application = null;
        try {
            arch = this.getVerifierContext().getAbstractArchive();
            archivist1 = ArchivistFactory.getArchivistForArchive(arch);
            application = archivist1.open(arch);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return application;
    }
}

