/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.wsclients;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.wsclients.WSClientCheck;
import com.sun.enterprise.tools.verifier.tests.wsclients.WSClientTest;

public class LargeIcon
extends WSClientTest
implements WSClientCheck {
    public Result check(ServiceReferenceDescriptor descriptor) {
        String largeIconString = descriptor.getLargeIconUri();
        Result result = this.doRealCheck(descriptor, largeIconString);
        return result;
    }

    public Result doRealCheck(Descriptor descriptor, String largeIconString) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor((ServiceReferenceDescriptor)descriptor);
        if (largeIconString != null) {
            if (!descriptor.getLargeIconUri().endsWith(".jpg") && !descriptor.getLargeIconUri().endsWith(".gif")) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The large-icon element [ {0} ] must end in .jpg or .gif within service-reference [ {1} ]", new Object[]{descriptor.getLargeIconUri(), compName.toString()}));
            } else {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The large-icon element [ {0} ] ends in .jpg or .gif within service-reference [ {1} ]", new Object[]{descriptor.getLargeIconUri(), compName.toString()}));
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "The large-icon element is not defined within service-reference [ {0} ]", new Object[]{compName.toString()}));
        }
        return result;
    }
}

