/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.wsclients;

import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.wsclients.WSClientCheck;
import com.sun.enterprise.tools.verifier.tests.wsclients.WSClientTest;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;

public class HandlerPortNameCheck
extends WSClientTest
implements WSClientCheck {
    public Result check(ServiceReferenceDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        if (descriptor.hasHandlers()) {
            Collection allPortNames = this.getAllPortNamesInService(descriptor);
            LinkedList handlerChain = descriptor.getHandlerChain();
            Iterator it = handlerChain.iterator();
            while (it.hasNext()) {
                Collection c = ((WebServiceHandler)it.next()).getPortNames();
                Collection invalid = this.getInvalidHandlerPortNames(c, allPortNames);
                if (invalid.size() > 0) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The Port Name(s) in the Handler Chain are invalid."));
                    continue;
                }
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Port Name(s) in the Handler-Chain are valid."));
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notapp", "Not Applicable since No handlers defined in this WebService."));
        }
        return result;
    }

    private Collection getAllPortNamesInService(ServiceReferenceDescriptor descriptor) {
        Set endPoints = descriptor.getPortsInfo();
        Vector<String> ret = new Vector<String>();
        Iterator it = endPoints.iterator();
        while (it.hasNext()) {
            ret.add(((ServiceRefPortInfo)it.next()).getPortComponentLinkName());
        }
        return ret;
    }

    private Collection getInvalidHandlerPortNames(Collection hpNames, Collection allPortNames) {
        Vector<String> ret = new Vector<String>();
        Iterator it = hpNames.iterator();
        while (it.hasNext()) {
            String currName = (String)it.next();
            if (allPortNames.contains(currName)) continue;
            ret.add(currName);
        }
        return ret;
    }
}

