/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;
import java.rmi.Remote;

public class SEIExtendsRemoteCheck
extends WSTest
implements WSCheck {
    public Result check(WebServiceEndpoint descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        boolean pass = true;
        try {
            String s = descriptor.getServiceEndpointInterface();
            if (s == null) {
                result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{"SEI Class Name Null"}));
            }
            ClassLoader cl = this.getVerifierContext().getClassLoader();
            Class<?> sei = null;
            try {
                sei = cl.loadClass(s);
            }
            catch (ClassNotFoundException e) {
                result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{e.getMessage()}));
                throw e;
            }
            if (Remote.class.isAssignableFrom(sei)) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "SEI [{0}] extends the java.rmi.Remote interface.", new Object[]{s}));
            } else {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "SEI [{0}] does not extend the java.rmi.Remote interface.", new Object[]{s}));
            }
        }
        catch (Exception e) {
            result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{e.getMessage()}));
        }
        return result;
    }
}

