/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;

public class JAXRPCEndpointIsServletClassCheck
extends WSTest
implements WSCheck {
    public Result check(WebServiceEndpoint wsdescriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(wsdescriptor);
        ClassLoader loader = this.getVerifierContext().getClassLoader();
        if (wsdescriptor.implementedByWebComponent()) {
            WebBundleDescriptor webBundle = (WebBundleDescriptor)wsdescriptor.getBundleDescriptor();
            WebComponentDescriptor webComponent = webBundle.getWebComponentByCanonicalName(wsdescriptor.getWebComponentLink());
            if (webComponent != null && webComponent.isServlet()) {
                String servletClass = wsdescriptor.getWebComponentImpl().getWebComponentImplementation();
                if (servletClass == null || !wsdescriptor.getWebComponentImpl().isServlet()) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.failed", "[{0}]", new Object[]{"The WebComponent implementation for this JAX-RPC endpoint is not a servlet"}));
                } else {
                    try {
                        Class<?> cl = loader.loadClass(servletClass);
                        result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.clpassed", "The [{0}] Class [{1}] exists and was loaded successfully.", new Object[]{"Servlet Class", servletClass}));
                    }
                    catch (ClassNotFoundException e) {
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.clfailed", "The [{0}] Class [{1}] could not be Loaded", new Object[]{"Servlet Class", servletClass}));
                    }
                }
            } else {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.failed", "[{0}]", new Object[]{"The servlet-link for this JAX-RPC Endpoint could not be resolved"}));
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.notapp", "[{0}]", new Object[]{"Not Applicable since this is NOT a JAX-RPC Service Endpoint"}));
        }
        return result;
    }
}

