/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.runtime;

import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.common.SecurityRoleMapping;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Enumeration;

public class ASSecurityRoleMapping
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        boolean oneFailed = false;
        try {
            SecurityRoleMapping[] secRoleMapp = descriptor.getSunDescriptor().getSecurityRoleMapping();
            if (secRoleMapp != null && secRoleMapp.length > 0) {
                for (int rep = 0; rep < secRoleMapp.length; ++rep) {
                    int rep1;
                    String roleName = secRoleMapp[rep].getRoleName();
                    String[] prinNames = secRoleMapp[rep].getPrincipalName();
                    String[] grpNames = secRoleMapp[rep].getGroupName();
                    if (this.validRoleName(roleName, descriptor)) {
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-WEB security-role-mapping] role-name [ {0} ] properly defined in the war file.", new Object[]{roleName}));
                    } else {
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-WEB security-role-mapping] role-name [ {0} ] is not valid, either empty or not defined in web.xml.", new Object[]{roleName}));
                        oneFailed = true;
                    }
                    if (prinNames != null && prinNames.length > 0) {
                        for (rep1 = 0; rep1 < prinNames.length; ++rep1) {
                            String prinName = prinNames[rep1].trim();
                            if (prinName != null && !"".equals(prinName)) {
                                this.addGoodDetails(result, compName);
                                result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "PASSED [AS-WEB security-role-mapping] principal-name [ {0} ] properly defined in the war file.", new Object[]{prinName}));
                                continue;
                            }
                            this.addErrorDetails(result, compName);
                            result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "FAILED [AS-WEB security-role-mapping] principal-name [ {0} ] cannot be empty string.", new Object[]{prinName}));
                            oneFailed = true;
                        }
                    }
                    if (grpNames == null || grpNames.length <= 0) continue;
                    for (rep1 = 0; rep1 < grpNames.length; ++rep1) {
                        String grpName = grpNames[rep1].trim();
                        if (grpName != null && !"".equals(grpName)) {
                            this.addGoodDetails(result, compName);
                            result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "PASSED [AS-WEB security-role-mapping] group-name [ {0} ] properly defined in the war file.", new Object[]{grpName}));
                            continue;
                        }
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-WEB security-role-mapping] group-name [ {0} ] cannot be an empty string.", new Object[]{grpName}));
                        oneFailed = true;
                    }
                }
            } else {
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-WEB sun-web-app] security-role-mapping element not defined in the web archive [ {0} ].", new Object[]{descriptor.getName()}));
                return result;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
                this.addGoodDetails(result, compName);
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed3", "PASSED [AS-WEB sun-web-app] security-role-mapping element(s) are valid within the web archive [ {0} ].", new Object[]{descriptor.getName()}));
            }
        }
        catch (Exception ex) {
            oneFailed = true;
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed3", "FAILED [AS-WEB security-role-mapping] could not create the security-role-mapping object"));
        }
        return result;
    }

    boolean validRoleName(String roleName, WebBundleDescriptor descriptor) {
        boolean valid = false;
        if (roleName != null && roleName.length() != 0) {
            Enumeration roles = descriptor.getSecurityRoles();
            while (roles != null && roles.hasMoreElements()) {
                SecurityRoleDescriptor roleDesc = (SecurityRoleDescriptor)roles.nextElement();
                String thisRoleName = roleDesc.getName();
                if (!roleName.equals(thisRoleName)) continue;
                valid = true;
                break;
            }
        }
        return valid;
    }
}

