/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.runtime;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.web.Cache;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;

public class ASCache
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        boolean oneFailed = false;
        boolean notApp = false;
        String maxEntries = null;
        String timeout = null;
        String enabled = null;
        try {
            Cache cache = descriptor.getSunDescriptor().getCache();
            if (cache != null) {
                boolean validTimeOutValue;
                boolean validMaxEntriesValue;
                block20: {
                    maxEntries = cache.getAttributeValue("MaxEntries");
                    timeout = cache.getAttributeValue("TimeoutInSeconds");
                    enabled = cache.getAttributeValue("Enabled");
                    if (!enabled.equalsIgnoreCase("true") && !enabled.equalsIgnoreCase("false")) {
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed3", "FAILED [AS-WEB cache] enabled  [ {0} ], attribute must be a proper boolean  value. ", new Object[]{enabled}));
                        oneFailed = true;
                    } else {
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed3", "PASSED [AS-WEB cache] enabled  [ {0} ] defined properly.", new Object[]{enabled}));
                    }
                    validMaxEntriesValue = true;
                    validTimeOutValue = true;
                    try {
                        if (maxEntries != null && maxEntries.length() != 0) {
                            int intMaxEntries = Integer.parseInt(maxEntries);
                            validMaxEntriesValue = intMaxEntries > 0 && intMaxEntries < Integer.MAX_VALUE;
                        }
                    }
                    catch (NumberFormatException exception) {
                        validMaxEntriesValue = false;
                        if (oneFailed) break block20;
                        oneFailed = true;
                    }
                }
                if (validMaxEntriesValue) {
                    this.addGoodDetails(result, compName);
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-WEB cache] max-entries [ {0} ] defined properly.", new Object[]{maxEntries}));
                } else {
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-WEB cache] max-entries [ {0} ], attribute must be a proper integer value. Its range should be 1 to MAX_INT.", new Object[]{maxEntries}));
                    oneFailed = true;
                }
                try {
                    if (timeout != null && timeout.length() != 0) {
                        long longTimeout = Long.parseLong(timeout);
                        validTimeOutValue = longTimeout >= -1L && longTimeout <= Long.MAX_VALUE;
                    }
                }
                catch (NumberFormatException exception) {
                    validTimeOutValue = false;
                    oneFailed = true;
                }
                if (validTimeOutValue) {
                    this.addGoodDetails(result, compName);
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "PASSED [AS-WEB cache] timeout-in-seconds  [ {0} ] defined properly.", new Object[]{timeout}));
                } else {
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "FAILED [AS-WEB cache] timeout-in-seconds value [ {0} ], attribute must be a proper long value. Its range should be between -1 and MAX_LONG.", new Object[]{timeout}));
                    oneFailed = true;
                }
            } else {
                notApp = true;
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-WEB cache] Element not defined for the web application.", new Object[]{descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (notApp) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        }
        catch (Exception ex) {
            oneFailed = true;
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-WEB cache] Could not create the cache object"));
        }
        return result;
    }
}

