/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.elements;

import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Iterator;
import java.util.Set;

public class WebEjbReferencesElement
extends WebTest
implements WebCheck {
    boolean oneFailed = false;

    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        String f = descriptor.getModuleDescriptor().getArchiveUri();
        this.loadWarFile(descriptor);
        result.notApplicable(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There is no ejb-ref inside [ {0} ].", new Object[]{compName}));
        result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName}));
        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        Set references = descriptor.getEjbReferenceDescriptors();
        Iterator iterator = references.iterator();
        while (iterator.hasNext()) {
            EjbReferenceDescriptor ejbReference = (EjbReferenceDescriptor)iterator.next();
            this.checkInterface(result, ejbReference, ejbReference.getEjbHomeInterface(), f);
            this.checkInterface(result, ejbReference, ejbReference.getEjbInterface(), f);
        }
        return result;
    }

    private void checkInterface(Result result, EjbReferenceDescriptor ejbRef, String intf, String f) {
        Class cl = this.loadClass(result, intf);
        if (cl == null) {
            this.oneFailed = true;
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: For ejb-ref element [ {0} ] the home/component interface class [ {1} ] is not loadable within [ {2} ].", new Object[]{ejbRef.getName(), intf, f}));
        } else if (!this.oneFailed) {
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "For ejb-ref element [ {0} ] the home/component interface class [ {1} ] is loadable within [ {2} ].", new Object[]{ejbRef.getName(), intf, f}));
        }
    }
}

