/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTestsUtil;
import java.io.File;

public abstract class WebTest
extends VerifierTest
implements VerifierCheck,
WebCheck {
    private boolean addedError = false;
    private boolean addedGood = false;
    private boolean addedNa = false;
    private boolean addedWarning = false;
    final String separator = System.getProperty("file.separator");
    Context context = null;

    public Result check(Descriptor descriptor) {
        return this.check((WebBundleDescriptor)descriptor);
    }

    public abstract Result check(WebBundleDescriptor var1);

    public Result loadWarFile(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        this.context = this.getVerifierContext();
        try {
            WebTestsUtil webTestsUtil = WebTestsUtil.getUtil(this.context.getClassLoader());
        }
        catch (Throwable e) {
            Verifier.debug(e);
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.web.WebTest.Exception", "Error: Unexpected exception occurred [ {0} ]", new Object[]{e.toString()}));
        }
        return result;
    }

    public Class loadClass(Result result, String className) {
        try {
            WebTestsUtil webTestsUtil = WebTestsUtil.getUtil(this.context.getClassLoader());
            return webTestsUtil.loadClass(className);
        }
        catch (Throwable e) {
            try {
                ClassLoader cl = this.getVerifierContext().getAlternateClassLoader();
                if (cl == null) {
                    throw e;
                }
                Class<?> c = cl.loadClass(className);
                return c;
            }
            catch (Throwable ex) {
                return null;
            }
        }
    }

    protected void deleteDirectory(String oneDir) {
        File cleanDir = new File(oneDir);
        if (!cleanDir.exists()) {
            return;
        }
        File[] listOfFiles = cleanDir.listFiles();
        if (listOfFiles != null) {
            for (int countFiles = 0; countFiles < listOfFiles.length; ++countFiles) {
                if (listOfFiles[countFiles].isFile()) {
                    listOfFiles[countFiles].delete();
                    continue;
                }
                String nextCleanDir = cleanDir + this.separator + listOfFiles[countFiles].getName();
                File newCleanDir = new File(nextCleanDir);
                this.deleteDirectory(newCleanDir.getAbsolutePath());
            }
        }
        cleanDir.delete();
    }

    protected String getAbstractArchiveUri(WebBundleDescriptor desc) {
        String archBase = this.getVerifierContext().getAbstractArchive().getArchiveUri();
        if (desc.getApplication() != null) {
            String moduleName = desc.getModuleDescriptor().getArchiveUri();
            if (!moduleName.endsWith(".war")) {
                return archBase;
            }
            String moduleDir = moduleName.replace('.', '_');
            String ret = archBase + File.separator + moduleDir;
            return ret;
        }
        return archBase;
    }

    protected void addGoodDetails(Result result, WebComponentNameConstructor compName) {
        if (this.addedGood) {
            return;
        }
        this.addedGood = true;
        result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
    }

    protected void addErrorDetails(Result result, WebComponentNameConstructor compName) {
        if (this.addedError) {
            return;
        }
        this.addedError = true;
        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
    }

    protected void addWarningDetails(Result result, WebComponentNameConstructor compName) {
        if (this.addedWarning) {
            return;
        }
        this.addedWarning = true;
        result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
    }

    protected void addNaDetails(Result result, WebComponentNameConstructor compName) {
        if (this.addedNa) {
            return;
        }
        this.addedNa = true;
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
    }
}

