/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Enumeration;
import java.util.logging.Level;

public class WebResourceType
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        if (descriptor.getResourceReferences().hasMoreElements()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            Enumeration e = descriptor.getResourceReferences();
            while (e.hasMoreElements()) {
                foundIt = false;
                ResourceReferenceDescriptor next = (ResourceReferenceDescriptor)e.nextElement();
                String resType = next.getType();
                this.logger.log(Level.FINE, "servlet resType: " + resType);
                if (resType.equals("javax.sql.DataSource") || resType.equals("javax.jms.QueueConnectionFactory") || resType.equals("javax.jms.TopicConnectionFactory") || resType.equals("javax.mail.Session") || resType.equals("java.net.URL")) {
                    foundIt = true;
                } else {
                    foundIt = false;
                    String specVerStr = descriptor.getSpecVersion();
                    double specVer = 0.0;
                    specVer = Double.valueOf(specVerStr);
                    if (Double.compare(specVer, 2.4) >= 0) {
                        foundIt = true;
                    }
                }
                if (foundIt) {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The resource-type [ {0} ] element specifies the Java class type of the data source within web application [ {1} ]", new Object[]{resType, descriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The resource-type [ {0} ] element does not specify valid Java class type of the data source within web application [ {1} ]", new Object[]{resType, descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no resource-type elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

