/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.JspConfigDescriptor;
import com.sun.enterprise.deployment.JspGroupDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import com.sun.enterprise.deployment.web.WebResourceCollection;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Enumeration;
import java.util.Iterator;

public abstract class URLPattern
extends WebTest
implements WebCheck {
    protected boolean oneFailed = false;
    protected boolean oneWarning = false;

    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        result.setStatus(3);
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There is no url-pattern element within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        this.checkWebResourceCollections(descriptor, result, compName);
        this.checkServletMappings(descriptor, result, compName);
        this.checkServletFilterMappings(descriptor, result, compName);
        this.checkJspGroupProperties(descriptor, result, compName);
        if (this.oneFailed) {
            result.setStatus(1);
        } else if (this.oneWarning) {
            result.setStatus(2);
        }
        return result;
    }

    protected abstract void checkUrlPatternAndSetResult(String var1, Descriptor var2, Result var3, WebComponentNameConstructor var4);

    private void checkWebResourceCollections(WebBundleDescriptor descriptor, Result result, WebComponentNameConstructor compName) {
        Enumeration e = descriptor.getSecurityConstraints();
        while (e.hasMoreElements()) {
            SecurityConstraint securityConstraint = (SecurityConstraint)e.nextElement();
            Enumeration ee = securityConstraint.getWebResourceCollections();
            while (ee.hasMoreElements()) {
                WebResourceCollection webResourceCollection = (WebResourceCollection)ee.nextElement();
                Enumeration eee = webResourceCollection.getUrlPatterns();
                while (eee.hasMoreElements()) {
                    this.checkUrlPatternAndSetResult((String)eee.nextElement(), descriptor, result, compName);
                }
            }
        }
    }

    private void checkServletMappings(WebBundleDescriptor descriptor, Result result, WebComponentNameConstructor compName) {
        Iterator iter = descriptor.getWebComponentDescriptorsSet().iterator();
        while (iter.hasNext()) {
            Iterator iter2 = ((WebComponentDescriptor)iter.next()).getUrlPatternsSet().iterator();
            while (iter2.hasNext()) {
                this.checkUrlPatternAndSetResult((String)iter2.next(), descriptor, result, compName);
            }
        }
    }

    private void checkServletFilterMappings(WebBundleDescriptor descriptor, Result result, WebComponentNameConstructor compName) {
        Iterator iter = descriptor.getServletFilterMappings().iterator();
        while (iter.hasNext()) {
            ServletFilterMapping filterMapping = (ServletFilterMapping)iter.next();
            if (!filterMapping.isURLPatternTarget()) continue;
            this.checkUrlPatternAndSetResult(filterMapping.getTarget(), descriptor, result, compName);
        }
    }

    private void checkJspGroupProperties(WebBundleDescriptor descriptor, Result result, WebComponentNameConstructor compName) {
        JspConfigDescriptor jspC = descriptor.getJspConfigDescriptor();
        if (jspC == null) {
            return;
        }
        Iterator iter = jspC.getJspGroupSet().iterator();
        while (iter.hasNext()) {
            Iterator iter2 = ((JspGroupDescriptor)iter.next()).getUrlPatternsSet().iterator();
            while (iter2.hasNext()) {
                this.checkUrlPatternAndSetResult((String)iter2.next(), descriptor, result, compName);
            }
        }
    }
}

