/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session.stateless;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;

public class StatelessCreateNoArgs
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = new ComponentNameConstructor(descriptor);
        if (descriptor instanceof EjbSessionDescriptor) {
            String stateType = ((EjbSessionDescriptor)descriptor).getSessionType();
            if ("Stateless".equals(stateType)) {
                if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                    this.commonToBothInterfaces(descriptor.getHomeClassName(), (EjbSessionDescriptor)descriptor);
                }
                if (descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                    this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), (EjbSessionDescriptor)descriptor);
                }
                if ((descriptor.getHomeClassName() == null || "".equals(descriptor.getHomeClassName())) && (descriptor.getLocalHomeClassName() == null || "".equals(descriptor.getLocalHomeClassName()))) {
                    if (this.implementsEndpoints(descriptor)) {
                        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                        this.result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.webservice.notapp", "Not Applicable because, EJB [ {0} ] implements a Service Endpoint Interface.", new Object[]{this.compName.toString()}));
                        this.result.setStatus(3);
                    } else {
                        this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                        this.result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.webservice.failedhome", "Ejb [ {0} ] does not have local or remote Home interfaces.", new Object[]{descriptor.getEjbClassName()}));
                        this.result.setStatus(1);
                    }
                }
                return this.result;
            }
            if ("Stateful".equals(stateType)) {
                this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "[ {0} ] expected {1} Session bean, but called with {2} Session bean.", new Object[]{this.getClass(), "Stateless", stateType}));
                return this.result;
            }
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "Error: [ {0} ] is not valid stateType within bean [ {1} ].", new Object[]{stateType, descriptor.getName()}));
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        return this.result;
    }

    private void commonToBothInterfaces(String home, EjbSessionDescriptor descriptor) {
        try {
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> c = jcl.loadClass(home);
            Method[] methods = c.getDeclaredMethods();
            Method m = null;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals("create")) continue;
                m = methods[i];
                break;
            }
            if (m != null) {
                Class<?>[] cc = m.getParameterTypes();
                if (cc.length > 0) {
                    this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The create method has one or more parameters \nwithin bean [ {0} ].  Stateless session are only allowed \nto have create methods with no arguments.", new Object[]{home}));
                } else {
                    this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Valid: This bean's [ {0} ] create method has no parameters.\nStateless session beans can only have a create method \nwith no parameters.", new Object[]{home}));
                }
            } else {
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "Error: No Create method exists within bean [ {0} ]", new Object[]{home}));
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Class [ {0} ] not found within bean [ {1} ]", new Object[]{home, descriptor.getName()}));
        }
    }
}

