/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session.ejbcreatemethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Vector;

public class EjbCreateMatchesCreate
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;
    boolean foundAtLeastOneCreate = false;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = new ComponentNameConstructor(descriptor);
        if (descriptor instanceof EjbSessionDescriptor) {
            if ((descriptor.getHomeClassName() == null || "".equals(descriptor.getHomeClassName())) && (descriptor.getLocalHomeClassName() == null || "".equals(descriptor.getLocalHomeClassName())) && this.implementsEndpoints(descriptor)) {
                this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.webservice.notapp", "Not Applicable because, EJB [ {0} ] implements a Service Endpoint Interface.", new Object[]{this.compName.toString()}));
                this.result.setStatus(3);
                return this.result;
            }
            boolean oneFailed = false;
            oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor.getLocalHomeClassName(), descriptor);
            if (oneFailed) {
                this.result.setStatus(1);
            } else {
                this.result.setStatus(0);
            }
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String remote, String local, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        try {
            int i;
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            boolean signaturesMatch = false;
            boolean found = false;
            Vector<Method> createMethodSuffix = new Vector<Method>();
            if (local != null) {
                Class<?> localhome = jcl.loadClass(local);
                Method[] localhomeMethods = localhome.getDeclaredMethods();
                for (i = 0; i < localhomeMethods.length; ++i) {
                    if (!localhomeMethods[i].getName().startsWith("create")) continue;
                    createMethodSuffix.addElement(localhomeMethods[i]);
                    this.foundAtLeastOneCreate = true;
                }
            }
            if (remote != null) {
                Class<?> home = jcl.loadClass(remote);
                Method[] homeMethods = home.getDeclaredMethods();
                for (i = 0; i < homeMethods.length; ++i) {
                    if (!homeMethods[i].getName().startsWith("create")) continue;
                    createMethodSuffix.addElement(homeMethods[i]);
                    this.foundAtLeastOneCreate = true;
                }
            }
            if (!this.foundAtLeastOneCreate) {
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException2", "Error: no create<Method> method exists!", new Object[0]));
                return true;
            }
            Class<?> EJBClass = jcl.loadClass(descriptor.getEjbClassName());
            Method[] methods = EJBClass.getMethods();
            for (int k = 0; k < createMethodSuffix.size(); ++k) {
                for (int j = 0; j < methods.length; ++j) {
                    Object[] businessMethodParameterTypes;
                    Object[] methodParameterTypes;
                    found = false;
                    if (!methods[j].getName().startsWith("ejbCreate")) continue;
                    found = true;
                    String matchSuffix = methods[j].getName().substring(9);
                    signaturesMatch = false;
                    if (!matchSuffix.equals(((Method)createMethodSuffix.elementAt(k)).getName().substring(6)) || !Arrays.equals(methodParameterTypes = ((Method)createMethodSuffix.elementAt(k)).getParameterTypes(), businessMethodParameterTypes = methods[j].getParameterTypes())) continue;
                    signaturesMatch = true;
                    this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface Method [ {0} ]", new Object[]{((Method)createMethodSuffix.elementAt(k)).getName()}));
                    this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The corresponding ejbCreate method with matching parameters was found."));
                    break;
                }
                if (signaturesMatch) continue;
                oneFailed = true;
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug3", "For Home Interface", new Object[0]));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: No corresponding ejbCreate<Method> method with matching parameters was found."));
            }
            if (!found && this.foundAtLeastOneCreate) {
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: ejbCreate<Method> method corresponding to the create<Method> method does not exist!", new Object[0]));
            }
            if (!found && !this.foundAtLeastOneCreate) {
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException2", "Error: no create<Method> method exists!", new Object[0]));
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home (Local/Remote) interface or  bean class [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{descriptor.getEjbClassName(), descriptor.getName()}));
            oneFailed = true;
            return oneFailed;
        }
    }
}

