/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class BeanFieldsTransient
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        if (descriptor instanceof EjbSessionDescriptor) {
            try {
                Context context = this.getVerifierContext();
                ClassLoader jcl = context.getClassLoader();
                Class<?> c = jcl.loadClass(((EjbSessionDescriptor)descriptor).getEjbClassName());
                boolean oneFailed = false;
                boolean badField = false;
                Field[] fields = c.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    badField = false;
                    int modifiers = fields[i].getModifiers();
                    if (!Modifier.isTransient(modifiers)) continue;
                    if (!oneFailed) {
                        oneFailed = true;
                    }
                    if (!(badField = true)) continue;
                    this.addWarningDetails(result, compName);
                    result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "Warning: Field [ {0} ] defined within session bean class [ {1} ] is defined as transient.  Session bean fields should not be defined in the session bean class as transient.", new Object[]{fields[i].getName(), ((EjbSessionDescriptor)descriptor).getEjbClassName()}));
                }
                if (!oneFailed) {
                    this.addGoodDetails(result, compName);
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "This session bean class [ {0} ] has defined all fields as non-transient fields.", new Object[]{((EjbSessionDescriptor)descriptor).getEjbClassName()}));
                }
            }
            catch (ClassNotFoundException e) {
                Verifier.debug(e);
                this.addErrorDetails(result, compName);
                result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{((EjbSessionDescriptor)descriptor).getEjbClassName()}));
            }
            catch (Throwable t) {
                this.addWarningDetails(result, compName);
                result.warning(smh.getLocalString(this.getClass().getName() + ".warningException", "Warning: [ {0} ] class encountered [ {1} ]. Cannot access fields of class [ {2} ] which is external to [ {3} ].", new Object[]{descriptor.getEjbClassName(), t.toString(), t.getMessage(), descriptor.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri()}));
            }
            return result;
        }
        this.addNaDetails(result, compName);
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} expected {1} bean, but called with {2}.", new Object[]{this.getClass(), "Session", "Entity"}));
        return result;
    }
}

