/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.runtime;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbExtraDescriptors;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;

public class ASEjbJMSMaxMessagesLoad
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        try {
            IASEjbExtraDescriptors iasEjbDescriptor = descriptor.getIASEjbExtraDescriptors();
            int value = iasEjbDescriptor.getJmsMaxMessagesLoad();
            Integer jmsMaxMsgs = new Integer(value);
            if (jmsMaxMsgs != null) {
                if (value < 1 || value > Integer.MAX_VALUE) {
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-EJB ejb] : {0} is not a valid value for jms-max-messages-load. It should be \nbetween 0 and MAX_INT", new Object[]{new Integer(value)}));
                } else {
                    this.addGoodDetails(result, compName);
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-EJB ejb] : jms-max-messages-load is {0}", new Object[]{jmsMaxMsgs}));
                }
            } else if (descriptor instanceof EjbMessageBeanDescriptor) {
                this.addWarningDetails(result, compName);
                result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "WARNING [AS-EJB ejb] : jms-max-messages-load should be defined for MDBs"));
            } else {
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-EJB ejb] : jms-max-messages-load element is not defined"));
            }
        }
        catch (Exception ex) {
            this.addErrorDetails(result, compName);
            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".notRun", "NOT RUN [AS-EJB] : Could not create a descriptor object"));
        }
        return result;
    }
}

