/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.runtime;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.IASEjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbCMPFinder;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ASEjbCMP
extends EjbTest
implements EjbCheck {
    public boolean oneFailed = false;
    public boolean oneWarning = false;

    public Result check(EjbDescriptor descriptor) {
        Result result;
        block20: {
            result = this.getInitializedResult();
            ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
            try {
                if (descriptor instanceof IASEjbCMPEntityDescriptor) {
                    IASEjbCMPEntityDescriptor cmpBean = (IASEjbCMPEntityDescriptor)descriptor;
                    if (cmpBean != null) {
                        String mappingProps = cmpBean.getMappingProperties();
                        if (mappingProps == null) {
                            this.oneWarning = true;
                            this.addWarningDetails(result, compName);
                            result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "WARNING [AS-EJB cmp] : mapping-properties Element is not defined"));
                        } else if (mappingProps.length() == 0) {
                            this.oneFailed = true;
                            this.addErrorDetails(result, compName);
                            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-EJB cmp] : mapping-properties field must contain a vaild non-empty value"));
                        } else {
                            JarFile jarFile = null;
                            ZipEntry deploymentEntry = null;
                            if (jarFile != null) {
                                deploymentEntry = jarFile.getEntry(mappingProps);
                            }
                            if (deploymentEntry != null) {
                                this.addGoodDetails(result, compName);
                                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-EJB cmp] : mapping-properties file is {0}", new Object[]{mappingProps}));
                            } else {
                                this.addErrorDetails(result, compName);
                                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-EJB cmp] : mapping-properties field must contain a vaild non-empty value"));
                            }
                        }
                        try {
                            boolean oneoneCmp = cmpBean.getCMPVersion() == 1;
                            this.addGoodDetails(result, compName);
                            result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "PASSED [AS-EJB cmp] : is-one-one-cmp is {0}", new Object[]{new Boolean(oneoneCmp)}));
                        }
                        catch (Exception ex) {
                            this.oneWarning = true;
                            this.addWarningDetails(result, compName);
                            result.warning(smh.getLocalString(this.getClass().getName() + ".warning1", "WARNING [AS-EJB cmp] : is-one-one-cmp Element is not defined"));
                        }
                        try {
                            Map finders = cmpBean.getOneOneFinders();
                            if (finders != null) {
                                this.testFinders(finders, result);
                            } else {
                                this.oneWarning = true;
                                this.addWarningDetails(result, compName);
                                result.warning(smh.getLocalString(this.getClass().getName() + ".warning2", "WARNING [AS-EJB cmp] : one-one-finders Element is not defined"));
                            }
                        }
                        catch (Exception ex) {
                            this.oneFailed = true;
                            this.addErrorDetails(result, compName);
                            result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "FAILED [AS-EJB cmp] : getOneOneFinders Failed.", new Object[]{cmpBean}));
                        }
                        if (this.oneFailed) {
                            result.setStatus(1);
                        } else if (this.oneWarning) {
                            result.setStatus(2);
                        }
                        break block20;
                    }
                    this.addNaDetails(result, compName);
                    result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-EJB cmp] : {0} is not a CMP Entity Bean.", new Object[]{descriptor.getName()}));
                    break block20;
                }
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-EJB cmp] : {0} is not a CMP Entity Bean.", new Object[]{descriptor.getName()}));
            }
            catch (Exception ex) {
                this.oneFailed = true;
                this.addErrorDetails(result, compName);
                result.failed(smh.getLocalString(this.getClass().getName() + ".notRun", "NOT RUN [AS-EJB cmp] Could not create descriptor Object."));
            }
        }
        return result;
    }

    public void testFinders(Map finders, Result result) {
        try {
            Set keySet = finders.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                IASEjbCMPFinder finder = (IASEjbCMPFinder)finders.get(obj);
                String methodName = finder.getMethodName();
                if (methodName.length() == 0) {
                    this.oneFailed = true;
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-EJB finder] : method-name cannot be an empty string."));
                } else {
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "PASSED [AS-EJB finder] : method-name is {0}", new Object[]{methodName}));
                }
                String value = finder.getQueryParameterDeclaration();
                this.testQuery(value, result, "finder", "query-params");
                value = finder.getQueryFilter();
                this.testQuery(value, result, "finder", "query-filter");
                value = finder.getQueryVariables();
                this.testQuery(value, result, "finder", "query-variables");
                value = finder.getQueryOrdering();
                this.testQuery(value, result, "finder", "query-ordering");
            }
        }
        catch (Exception ex) {
            this.oneFailed = true;
            result.failed(smh.getLocalString(this.getClass().getName() + ".notRun", "NOT RUN [AS-EJB cmp] Could not create descriptor Object."));
        }
    }

    public void testQuery(String value, Result result, String parent, String child) {
        if (value == null) {
            this.oneWarning = true;
            result.warning(smh.getLocalString(this.getClass().getName() + ".warning3", "WARNING [AS-EJB {0}] : {1} Element is not defined", new Object[]{parent, child}));
        } else if (value.length() == 0) {
            this.oneFailed = true;
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed3", "FAILED [AS-EJB {0}] : {1} cannot be an empty string", new Object[]{parent, child}));
        } else {
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed3", "PASSED [AS-EJB {0}] : {1} is/are {2}", new Object[]{parent, child, value}));
        }
    }
}

