/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.intf.remoteintf;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import java.util.logging.Level;

public class RemoteInterfaceSuperInterface
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        if (!(descriptor instanceof EjbSessionDescriptor) && !(descriptor instanceof EjbEntityDescriptor)) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.homeintf.HomeMethodTest.notApplicable1", "Test apply only to session or entity beans."));
            return result;
        }
        if (descriptor.getRemoteClassName() == null || "".equals(descriptor.getRemoteClassName())) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.localinterfaceonly.notapp", "Not Applicable because, EJB [ {0} ] has Local Interfaces only.", new Object[]{descriptor.getEjbClassName()}));
            return result;
        }
        boolean oneFailed = false;
        try {
            Class<?> c;
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> remote = c = jcl.loadClass(descriptor.getRemoteClassName());
            boolean validRemoteInterface = false;
            boolean ok = false;
            block2: do {
                Class<?>[] interfaces;
                if ((interfaces = c.getInterfaces()).length == 0) {
                    ok = true;
                }
                for (int i = 0; i < interfaces.length; ++i) {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug1", new Object[]{interfaces[i].getName()});
                    if (!ok) {
                        ok = RmiIIOPUtils.isValidRmiIIOPInterface(interfaces[i]);
                    }
                    if (RmiIIOPUtils.isValidRmiIIOPInterfaceMethods(interfaces[i])) {
                        if (!interfaces[i].getName().equals("javax.ejb.EJBObject")) continue;
                        validRemoteInterface = true;
                        continue block2;
                    }
                    oneFailed = true;
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] does not properly conform to rules of RMI-IIOP for superinterfaces.  All enterprise beans remote interfaces are allowed to have superinterfaces that conform to the rules of RMI-IIOP for superinterfaces .  [ {1} ] is not a valid remote interface.", new Object[]{interfaces[i].getName(), descriptor.getRemoteClassName()}));
                }
            } while ((c = c.getSuperclass()) != null && !validRemoteInterface);
            if (!ok) {
                oneFailed = true;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] does not properly conform to rules of RMI-IIOP for superinterfaces.  All enterprise beans remote interfaces are allowed to have superinterfaces that conform to the rules of RMI-IIOP for superinterfaces .  [ {1} ] is not a valid remote interface.", new Object[]{remote.getName(), descriptor.getRemoteClassName()}));
            }
            if (validRemoteInterface) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] properly conforms to rules of RMI-IIOP for superinterfaces.", new Object[]{descriptor.getRemoteClassName()}));
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Remote interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{descriptor.getRemoteClassName(), descriptor.getName()}));
            oneFailed = true;
        }
        if (oneFailed) {
            result.setStatus(1);
        } else {
            result.setStatus(0);
        }
        return result;
    }
}

