/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.homeintf.remotehomeintf;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import java.util.logging.Level;

public class RemoteHomeInterfaceSuperInterface
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        if (descriptor.getHomeClassName() == null || "".equals(descriptor.getHomeClassName())) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.localinterfaceonly.notapp", "Not Applicable because, EJB [ {0} ] has Local Interfaces only.", new Object[]{descriptor.getEjbClassName()}));
            return result;
        }
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            boolean oneFailed = false;
            boolean ok = false;
            try {
                Class<?> c;
                Context context = this.getVerifierContext();
                ClassLoader jcl = context.getClassLoader();
                Class<?> remote = c = jcl.loadClass(descriptor.getHomeClassName());
                boolean validHomeInterface = false;
                block2: do {
                    Class<?>[] interfaces;
                    if ((interfaces = c.getInterfaces()).length == 0) {
                        ok = true;
                    }
                    for (int i = 0; i < interfaces.length; ++i) {
                        this.logger.log(Level.FINE, this.getClass().getName() + ".debug1", new Object[]{interfaces[i].getName()});
                        if (!ok) {
                            ok = RmiIIOPUtils.isValidRmiIIOPInterface(interfaces[i]);
                        }
                        if (RmiIIOPUtils.isValidRmiIIOPInterfaceMethods(interfaces[i])) {
                            if (!interfaces[i].getName().equals("javax.ejb.EJBHome")) continue;
                            validHomeInterface = true;
                            continue block2;
                        }
                        oneFailed = true;
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] does not properly conform to rules of RMI-IIOP for superinterfaces.  All enterprise beans home interfaces are allowed to have superinterfaces that conform to the rules of RMI-IIOP for superinterfaces .  [ {1} ] is not a valid home interface.", new Object[]{interfaces[i].getName(), descriptor.getHomeClassName()}));
                    }
                } while ((c = c.getSuperclass()) != null && !validHomeInterface);
                if (!ok) {
                    oneFailed = true;
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] does not properly conform to rules of RMI-IIOP for superinterfaces.  All enterprise beans home interfaces are allowed to have superinterfaces that conform to the rules of RMI-IIOP for superinterfaces .  [{1} ] is not a valid home interface.", new Object[]{remote.getName(), descriptor.getHomeClassName()}));
                }
                if (validHomeInterface) {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] properly conforms to rules of RMI-IIOP for superinterfaces.", new Object[]{descriptor.getHomeClassName()}));
                }
            }
            catch (ClassNotFoundException e) {
                Verifier.debug(e);
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{descriptor.getHomeClassName(), descriptor.getName()}));
                oneFailed = true;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} expected {1} bean or {2} bean, but called with {3}.", new Object[]{this.getClass(), "Session", "Entity", descriptor.getName()}));
        return result;
    }
}

