/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.homeintf;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Modifier;

public abstract class HomeInterfacePublic
extends EjbTest
implements EjbCheck {
    protected abstract String getHomeInterfaceName(EjbDescriptor var1);

    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        if (this.getHomeInterfaceName(descriptor) == null || "".equals(this.getHomeInterfaceName(descriptor))) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.localinterfaceonly.notapp", "Not Applicable because, EJB [ {0} ] has Local Interfaces only.", new Object[]{descriptor.getEjbClassName()}));
            return result;
        }
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            try {
                Context context = this.getVerifierContext();
                ClassLoader jcl = context.getClassLoader();
                Class<?> c = jcl.loadClass(this.getClassName(descriptor));
                boolean isPublic = false;
                int modifiers = c.getModifiers();
                if (Modifier.isPublic(modifiers)) {
                    isPublic = true;
                }
                if (!isPublic) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] is not defined as public.  All enterprise beans home interfaces must be defined as public.  [ {1} ] is not a valid home interface.", new Object[]{this.getClassName(descriptor), this.getClassName(descriptor)}));
                } else {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] properly declares the home interface as public.", new Object[]{this.getClassName(descriptor)}));
                }
            }
            catch (ClassNotFoundException e) {
                Verifier.debug(e);
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{this.getClassName(descriptor)}));
            }
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean or {2} bean, but called with {3}.", new Object[]{this.getClass(), "Session", "Entity", descriptor.getName()}));
        return result;
    }

    private String getClassName(EjbDescriptor descriptor) {
        return this.getHomeInterfaceName(descriptor);
    }
}

